/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.Availability;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.SoftwareSource;
import com.oracle.bmc.osmanagementhub.model.SoftwareSourceType;
import com.oracle.bmc.osmanagementhub.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListSoftwarePackageSoftwareSourcesRequest
extends BmcRequest<Void> {
    private String softwarePackageName;
    private String compartmentId;
    private List<SoftwareSourceType> softwareSourceType;
    private List<OsFamily> osFamily;
    private List<ArchType> archType;
    private List<Availability> availability;
    private List<Availability> availabilityAtOci;
    private List<Availability> availabilityAnywhere;
    private String displayName;
    private String displayNameContains;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private List<SoftwareSource.LifecycleState> lifecycleState;
    private String opcRequestId;

    public String getSoftwarePackageName() {
        return this.softwarePackageName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<SoftwareSourceType> getSoftwareSourceType() {
        return this.softwareSourceType;
    }

    public List<OsFamily> getOsFamily() {
        return this.osFamily;
    }

    public List<ArchType> getArchType() {
        return this.archType;
    }

    public List<Availability> getAvailability() {
        return this.availability;
    }

    public List<Availability> getAvailabilityAtOci() {
        return this.availabilityAtOci;
    }

    public List<Availability> getAvailabilityAnywhere() {
        return this.availabilityAnywhere;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public List<SoftwareSource.LifecycleState> getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().softwarePackageName(this.softwarePackageName).compartmentId(this.compartmentId).softwareSourceType(this.softwareSourceType).osFamily(this.osFamily).archType(this.archType).availability(this.availability).availabilityAtOci(this.availabilityAtOci).availabilityAnywhere(this.availabilityAnywhere).displayName(this.displayName).displayNameContains(this.displayNameContains).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).lifecycleState(this.lifecycleState).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",softwarePackageName=").append(String.valueOf(this.softwarePackageName));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",softwareSourceType=").append(String.valueOf(this.softwareSourceType));
        sb.append(",osFamily=").append(String.valueOf(this.osFamily));
        sb.append(",archType=").append(String.valueOf(this.archType));
        sb.append(",availability=").append(String.valueOf(this.availability));
        sb.append(",availabilityAtOci=").append(String.valueOf(this.availabilityAtOci));
        sb.append(",availabilityAnywhere=").append(String.valueOf(this.availabilityAnywhere));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSoftwarePackageSoftwareSourcesRequest)) {
            return false;
        }
        ListSoftwarePackageSoftwareSourcesRequest other = (ListSoftwarePackageSoftwareSourcesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.softwarePackageName, other.softwarePackageName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.softwareSourceType, other.softwareSourceType) && Objects.equals(this.osFamily, other.osFamily) && Objects.equals(this.archType, other.archType) && Objects.equals(this.availability, other.availability) && Objects.equals(this.availabilityAtOci, other.availabilityAtOci) && Objects.equals(this.availabilityAnywhere, other.availabilityAnywhere) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.lifecycleState, other.lifecycleState) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.softwarePackageName == null ? 43 : this.softwarePackageName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.softwareSourceType == null ? 43 : this.softwareSourceType.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.archType == null ? 43 : this.archType.hashCode());
        result = result * 59 + (this.availability == null ? 43 : this.availability.hashCode());
        result = result * 59 + (this.availabilityAtOci == null ? 43 : this.availabilityAtOci.hashCode());
        result = result * 59 + (this.availabilityAnywhere == null ? 43 : this.availabilityAnywhere.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSoftwarePackageSoftwareSourcesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String softwarePackageName = null;
        private String compartmentId = null;
        private List<SoftwareSourceType> softwareSourceType = null;
        private List<OsFamily> osFamily = null;
        private List<ArchType> archType = null;
        private List<Availability> availability = null;
        private List<Availability> availabilityAtOci = null;
        private List<Availability> availabilityAnywhere = null;
        private String displayName = null;
        private String displayNameContains = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private List<SoftwareSource.LifecycleState> lifecycleState = null;
        private String opcRequestId = null;

        public Builder softwarePackageName(String softwarePackageName) {
            this.softwarePackageName = softwarePackageName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder softwareSourceType(List<SoftwareSourceType> softwareSourceType) {
            this.softwareSourceType = softwareSourceType;
            return this;
        }

        public Builder softwareSourceType(SoftwareSourceType singularValue) {
            return this.softwareSourceType(Arrays.asList(singularValue));
        }

        public Builder osFamily(List<OsFamily> osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder osFamily(OsFamily singularValue) {
            return this.osFamily(Arrays.asList(singularValue));
        }

        public Builder archType(List<ArchType> archType) {
            this.archType = archType;
            return this;
        }

        public Builder archType(ArchType singularValue) {
            return this.archType(Arrays.asList(singularValue));
        }

        public Builder availability(List<Availability> availability) {
            this.availability = availability;
            return this;
        }

        public Builder availability(Availability singularValue) {
            return this.availability(Arrays.asList(singularValue));
        }

        public Builder availabilityAtOci(List<Availability> availabilityAtOci) {
            this.availabilityAtOci = availabilityAtOci;
            return this;
        }

        public Builder availabilityAtOci(Availability singularValue) {
            return this.availabilityAtOci(Arrays.asList(singularValue));
        }

        public Builder availabilityAnywhere(List<Availability> availabilityAnywhere) {
            this.availabilityAnywhere = availabilityAnywhere;
            return this;
        }

        public Builder availabilityAnywhere(Availability singularValue) {
            return this.availabilityAnywhere(Arrays.asList(singularValue));
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder lifecycleState(List<SoftwareSource.LifecycleState> lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder lifecycleState(SoftwareSource.LifecycleState singularValue) {
            return this.lifecycleState(Arrays.asList(singularValue));
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSoftwarePackageSoftwareSourcesRequest o) {
            this.softwarePackageName(o.getSoftwarePackageName());
            this.compartmentId(o.getCompartmentId());
            this.softwareSourceType(o.getSoftwareSourceType());
            this.osFamily(o.getOsFamily());
            this.archType(o.getArchType());
            this.availability(o.getAvailability());
            this.availabilityAtOci(o.getAvailabilityAtOci());
            this.availabilityAnywhere(o.getAvailabilityAnywhere());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.lifecycleState(o.getLifecycleState());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSoftwarePackageSoftwareSourcesRequest build() {
            ListSoftwarePackageSoftwareSourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSoftwarePackageSoftwareSourcesRequest buildWithoutInvocationCallback() {
            ListSoftwarePackageSoftwareSourcesRequest request = new ListSoftwarePackageSoftwareSourcesRequest();
            request.softwarePackageName = this.softwarePackageName;
            request.compartmentId = this.compartmentId;
            request.softwareSourceType = this.softwareSourceType;
            request.osFamily = this.osFamily;
            request.archType = this.archType;
            request.availability = this.availability;
            request.availabilityAtOci = this.availabilityAtOci;
            request.availabilityAnywhere = this.availabilityAnywhere;
            request.displayName = this.displayName;
            request.displayNameContains = this.displayNameContains;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.lifecycleState = this.lifecycleState;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

