/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.Availability;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.SoftwareSource;
import com.oracle.bmc.osmanagementhub.model.SoftwareSourceType;
import com.oracle.bmc.osmanagementhub.model.SortOrder;
import com.oracle.bmc.osmanagementhub.model.VendorName;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListSoftwareSourcesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String softwareSourceId;
    private List<SoftwareSourceType> softwareSourceType;
    private VendorName vendorName;
    private List<OsFamily> osFamily;
    private List<ArchType> archType;
    private List<Availability> availability;
    private List<Availability> availabilityAtOci;
    private List<Availability> availabilityAnywhere;
    private Boolean isMandatoryForAutonomousLinux;
    private String displayName;
    private String displayNameContains;
    private List<String> displayNameNotEqualTo;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private List<SoftwareSource.LifecycleState> lifecycleState;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public List<SoftwareSourceType> getSoftwareSourceType() {
        return this.softwareSourceType;
    }

    public VendorName getVendorName() {
        return this.vendorName;
    }

    public List<OsFamily> getOsFamily() {
        return this.osFamily;
    }

    public List<ArchType> getArchType() {
        return this.archType;
    }

    public List<Availability> getAvailability() {
        return this.availability;
    }

    public List<Availability> getAvailabilityAtOci() {
        return this.availabilityAtOci;
    }

    public List<Availability> getAvailabilityAnywhere() {
        return this.availabilityAnywhere;
    }

    public Boolean getIsMandatoryForAutonomousLinux() {
        return this.isMandatoryForAutonomousLinux;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public List<String> getDisplayNameNotEqualTo() {
        return this.displayNameNotEqualTo;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public List<SoftwareSource.LifecycleState> getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).softwareSourceId(this.softwareSourceId).softwareSourceType(this.softwareSourceType).vendorName(this.vendorName).osFamily(this.osFamily).archType(this.archType).availability(this.availability).availabilityAtOci(this.availabilityAtOci).availabilityAnywhere(this.availabilityAnywhere).isMandatoryForAutonomousLinux(this.isMandatoryForAutonomousLinux).displayName(this.displayName).displayNameContains(this.displayNameContains).displayNameNotEqualTo(this.displayNameNotEqualTo).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).lifecycleState(this.lifecycleState).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",softwareSourceId=").append(String.valueOf(this.softwareSourceId));
        sb.append(",softwareSourceType=").append(String.valueOf(this.softwareSourceType));
        sb.append(",vendorName=").append(String.valueOf((Object)this.vendorName));
        sb.append(",osFamily=").append(String.valueOf(this.osFamily));
        sb.append(",archType=").append(String.valueOf(this.archType));
        sb.append(",availability=").append(String.valueOf(this.availability));
        sb.append(",availabilityAtOci=").append(String.valueOf(this.availabilityAtOci));
        sb.append(",availabilityAnywhere=").append(String.valueOf(this.availabilityAnywhere));
        sb.append(",isMandatoryForAutonomousLinux=").append(String.valueOf(this.isMandatoryForAutonomousLinux));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",displayNameNotEqualTo=").append(String.valueOf(this.displayNameNotEqualTo));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSoftwareSourcesRequest)) {
            return false;
        }
        ListSoftwareSourcesRequest other = (ListSoftwareSourcesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.softwareSourceId, other.softwareSourceId) && Objects.equals(this.softwareSourceType, other.softwareSourceType) && Objects.equals((Object)this.vendorName, (Object)other.vendorName) && Objects.equals(this.osFamily, other.osFamily) && Objects.equals(this.archType, other.archType) && Objects.equals(this.availability, other.availability) && Objects.equals(this.availabilityAtOci, other.availabilityAtOci) && Objects.equals(this.availabilityAnywhere, other.availabilityAnywhere) && Objects.equals(this.isMandatoryForAutonomousLinux, other.isMandatoryForAutonomousLinux) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals(this.displayNameNotEqualTo, other.displayNameNotEqualTo) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.lifecycleState, other.lifecycleState) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.softwareSourceId == null ? 43 : this.softwareSourceId.hashCode());
        result = result * 59 + (this.softwareSourceType == null ? 43 : this.softwareSourceType.hashCode());
        result = result * 59 + (this.vendorName == null ? 43 : this.vendorName.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.archType == null ? 43 : this.archType.hashCode());
        result = result * 59 + (this.availability == null ? 43 : this.availability.hashCode());
        result = result * 59 + (this.availabilityAtOci == null ? 43 : this.availabilityAtOci.hashCode());
        result = result * 59 + (this.availabilityAnywhere == null ? 43 : this.availabilityAnywhere.hashCode());
        result = result * 59 + (this.isMandatoryForAutonomousLinux == null ? 43 : this.isMandatoryForAutonomousLinux.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.displayNameNotEqualTo == null ? 43 : this.displayNameNotEqualTo.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSoftwareSourcesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String softwareSourceId = null;
        private List<SoftwareSourceType> softwareSourceType = null;
        private VendorName vendorName = null;
        private List<OsFamily> osFamily = null;
        private List<ArchType> archType = null;
        private List<Availability> availability = null;
        private List<Availability> availabilityAtOci = null;
        private List<Availability> availabilityAnywhere = null;
        private Boolean isMandatoryForAutonomousLinux = null;
        private String displayName = null;
        private String displayNameContains = null;
        private List<String> displayNameNotEqualTo = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private List<SoftwareSource.LifecycleState> lifecycleState = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            return this;
        }

        public Builder softwareSourceType(List<SoftwareSourceType> softwareSourceType) {
            this.softwareSourceType = softwareSourceType;
            return this;
        }

        public Builder softwareSourceType(SoftwareSourceType singularValue) {
            return this.softwareSourceType(Arrays.asList(singularValue));
        }

        public Builder vendorName(VendorName vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public Builder osFamily(List<OsFamily> osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder osFamily(OsFamily singularValue) {
            return this.osFamily(Arrays.asList(singularValue));
        }

        public Builder archType(List<ArchType> archType) {
            this.archType = archType;
            return this;
        }

        public Builder archType(ArchType singularValue) {
            return this.archType(Arrays.asList(singularValue));
        }

        public Builder availability(List<Availability> availability) {
            this.availability = availability;
            return this;
        }

        public Builder availability(Availability singularValue) {
            return this.availability(Arrays.asList(singularValue));
        }

        public Builder availabilityAtOci(List<Availability> availabilityAtOci) {
            this.availabilityAtOci = availabilityAtOci;
            return this;
        }

        public Builder availabilityAtOci(Availability singularValue) {
            return this.availabilityAtOci(Arrays.asList(singularValue));
        }

        public Builder availabilityAnywhere(List<Availability> availabilityAnywhere) {
            this.availabilityAnywhere = availabilityAnywhere;
            return this;
        }

        public Builder availabilityAnywhere(Availability singularValue) {
            return this.availabilityAnywhere(Arrays.asList(singularValue));
        }

        public Builder isMandatoryForAutonomousLinux(Boolean isMandatoryForAutonomousLinux) {
            this.isMandatoryForAutonomousLinux = isMandatoryForAutonomousLinux;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder displayNameNotEqualTo(List<String> displayNameNotEqualTo) {
            this.displayNameNotEqualTo = displayNameNotEqualTo;
            return this;
        }

        public Builder displayNameNotEqualTo(String singularValue) {
            return this.displayNameNotEqualTo(Arrays.asList(singularValue));
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder lifecycleState(List<SoftwareSource.LifecycleState> lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder lifecycleState(SoftwareSource.LifecycleState singularValue) {
            return this.lifecycleState(Arrays.asList(singularValue));
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSoftwareSourcesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.softwareSourceId(o.getSoftwareSourceId());
            this.softwareSourceType(o.getSoftwareSourceType());
            this.vendorName(o.getVendorName());
            this.osFamily(o.getOsFamily());
            this.archType(o.getArchType());
            this.availability(o.getAvailability());
            this.availabilityAtOci(o.getAvailabilityAtOci());
            this.availabilityAnywhere(o.getAvailabilityAnywhere());
            this.isMandatoryForAutonomousLinux(o.getIsMandatoryForAutonomousLinux());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.displayNameNotEqualTo(o.getDisplayNameNotEqualTo());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.lifecycleState(o.getLifecycleState());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSoftwareSourcesRequest build() {
            ListSoftwareSourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSoftwareSourcesRequest buildWithoutInvocationCallback() {
            ListSoftwareSourcesRequest request = new ListSoftwareSourcesRequest();
            request.compartmentId = this.compartmentId;
            request.softwareSourceId = this.softwareSourceId;
            request.softwareSourceType = this.softwareSourceType;
            request.vendorName = this.vendorName;
            request.osFamily = this.osFamily;
            request.archType = this.archType;
            request.availability = this.availability;
            request.availabilityAtOci = this.availabilityAtOci;
            request.availabilityAnywhere = this.availabilityAnywhere;
            request.isMandatoryForAutonomousLinux = this.isMandatoryForAutonomousLinux;
            request.displayName = this.displayName;
            request.displayNameContains = this.displayNameContains;
            request.displayNameNotEqualTo = this.displayNameNotEqualTo;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.lifecycleState = this.lifecycleState;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

