/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.OperationStatus;
import com.oracle.bmc.osmanagementhub.model.SortOrder;
import com.oracle.bmc.osmanagementhub.model.WorkRequestOperationType;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListWorkRequestsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String workRequestId;
    private List<OperationStatus> status;
    private String resourceId;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String initiatorId;
    private String parentId;
    private List<String> parentResourcesNotEqualTo;
    private List<WorkRequestOperationType> operationType;
    private String displayNameContains;
    private String retryOfId;
    private Date timeCreatedLessThan;
    private Date timeCreatedGreaterThanOrEqualTo;
    private Boolean isManagedByAutonomousLinux;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public List<OperationStatus> getStatus() {
        return this.status;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public List<String> getParentResourcesNotEqualTo() {
        return this.parentResourcesNotEqualTo;
    }

    public List<WorkRequestOperationType> getOperationType() {
        return this.operationType;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public String getRetryOfId() {
        return this.retryOfId;
    }

    public Date getTimeCreatedLessThan() {
        return this.timeCreatedLessThan;
    }

    public Date getTimeCreatedGreaterThanOrEqualTo() {
        return this.timeCreatedGreaterThanOrEqualTo;
    }

    public Boolean getIsManagedByAutonomousLinux() {
        return this.isManagedByAutonomousLinux;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).workRequestId(this.workRequestId).status(this.status).resourceId(this.resourceId).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit).sortOrder(this.sortOrder).sortBy(this.sortBy).initiatorId(this.initiatorId).parentId(this.parentId).parentResourcesNotEqualTo(this.parentResourcesNotEqualTo).operationType(this.operationType).displayNameContains(this.displayNameContains).retryOfId(this.retryOfId).timeCreatedLessThan(this.timeCreatedLessThan).timeCreatedGreaterThanOrEqualTo(this.timeCreatedGreaterThanOrEqualTo).isManagedByAutonomousLinux(this.isManagedByAutonomousLinux);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(",status=").append(String.valueOf(this.status));
        sb.append(",resourceId=").append(String.valueOf(this.resourceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",initiatorId=").append(String.valueOf(this.initiatorId));
        sb.append(",parentId=").append(String.valueOf(this.parentId));
        sb.append(",parentResourcesNotEqualTo=").append(String.valueOf(this.parentResourcesNotEqualTo));
        sb.append(",operationType=").append(String.valueOf(this.operationType));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",retryOfId=").append(String.valueOf(this.retryOfId));
        sb.append(",timeCreatedLessThan=").append(String.valueOf(this.timeCreatedLessThan));
        sb.append(",timeCreatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeCreatedGreaterThanOrEqualTo));
        sb.append(",isManagedByAutonomousLinux=").append(String.valueOf(this.isManagedByAutonomousLinux));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListWorkRequestsRequest)) {
            return false;
        }
        ListWorkRequestsRequest other = (ListWorkRequestsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.workRequestId, other.workRequestId) && Objects.equals(this.status, other.status) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.initiatorId, other.initiatorId) && Objects.equals(this.parentId, other.parentId) && Objects.equals(this.parentResourcesNotEqualTo, other.parentResourcesNotEqualTo) && Objects.equals(this.operationType, other.operationType) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals(this.retryOfId, other.retryOfId) && Objects.equals(this.timeCreatedLessThan, other.timeCreatedLessThan) && Objects.equals(this.timeCreatedGreaterThanOrEqualTo, other.timeCreatedGreaterThanOrEqualTo) && Objects.equals(this.isManagedByAutonomousLinux, other.isManagedByAutonomousLinux);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.initiatorId == null ? 43 : this.initiatorId.hashCode());
        result = result * 59 + (this.parentId == null ? 43 : this.parentId.hashCode());
        result = result * 59 + (this.parentResourcesNotEqualTo == null ? 43 : this.parentResourcesNotEqualTo.hashCode());
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.retryOfId == null ? 43 : this.retryOfId.hashCode());
        result = result * 59 + (this.timeCreatedLessThan == null ? 43 : this.timeCreatedLessThan.hashCode());
        result = result * 59 + (this.timeCreatedGreaterThanOrEqualTo == null ? 43 : this.timeCreatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.isManagedByAutonomousLinux == null ? 43 : this.isManagedByAutonomousLinux.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWorkRequestsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String workRequestId = null;
        private List<OperationStatus> status = null;
        private String resourceId = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String initiatorId = null;
        private String parentId = null;
        private List<String> parentResourcesNotEqualTo = null;
        private List<WorkRequestOperationType> operationType = null;
        private String displayNameContains = null;
        private String retryOfId = null;
        private Date timeCreatedLessThan = null;
        private Date timeCreatedGreaterThanOrEqualTo = null;
        private Boolean isManagedByAutonomousLinux = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder status(List<OperationStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(OperationStatus singularValue) {
            return this.status(Arrays.asList(singularValue));
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder initiatorId(String initiatorId) {
            this.initiatorId = initiatorId;
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder parentResourcesNotEqualTo(List<String> parentResourcesNotEqualTo) {
            this.parentResourcesNotEqualTo = parentResourcesNotEqualTo;
            return this;
        }

        public Builder parentResourcesNotEqualTo(String singularValue) {
            return this.parentResourcesNotEqualTo(Arrays.asList(singularValue));
        }

        public Builder operationType(List<WorkRequestOperationType> operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder operationType(WorkRequestOperationType singularValue) {
            return this.operationType(Arrays.asList(singularValue));
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder retryOfId(String retryOfId) {
            this.retryOfId = retryOfId;
            return this;
        }

        public Builder timeCreatedLessThan(Date timeCreatedLessThan) {
            this.timeCreatedLessThan = timeCreatedLessThan;
            return this;
        }

        public Builder timeCreatedGreaterThanOrEqualTo(Date timeCreatedGreaterThanOrEqualTo) {
            this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder isManagedByAutonomousLinux(Boolean isManagedByAutonomousLinux) {
            this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.workRequestId(o.getWorkRequestId());
            this.status(o.getStatus());
            this.resourceId(o.getResourceId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.initiatorId(o.getInitiatorId());
            this.parentId(o.getParentId());
            this.parentResourcesNotEqualTo(o.getParentResourcesNotEqualTo());
            this.operationType(o.getOperationType());
            this.displayNameContains(o.getDisplayNameContains());
            this.retryOfId(o.getRetryOfId());
            this.timeCreatedLessThan(o.getTimeCreatedLessThan());
            this.timeCreatedGreaterThanOrEqualTo(o.getTimeCreatedGreaterThanOrEqualTo());
            this.isManagedByAutonomousLinux(o.getIsManagedByAutonomousLinux());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestsRequest build() {
            ListWorkRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListWorkRequestsRequest buildWithoutInvocationCallback() {
            ListWorkRequestsRequest request = new ListWorkRequestsRequest();
            request.compartmentId = this.compartmentId;
            request.workRequestId = this.workRequestId;
            request.status = this.status;
            request.resourceId = this.resourceId;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.initiatorId = this.initiatorId;
            request.parentId = this.parentId;
            request.parentResourcesNotEqualTo = this.parentResourcesNotEqualTo;
            request.operationType = this.operationType;
            request.displayNameContains = this.displayNameContains;
            request.retryOfId = this.retryOfId;
            request.timeCreatedLessThan = this.timeCreatedLessThan;
            request.timeCreatedGreaterThanOrEqualTo = this.timeCreatedGreaterThanOrEqualTo;
            request.isManagedByAutonomousLinux = this.isManagedByAutonomousLinux;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

