/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceLocation;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceStatus;
import com.oracle.bmc.osmanagementhub.model.MetricName;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SummarizeManagedInstanceAnalyticsRequest
extends BmcRequest<Void> {
    private List<MetricName> metricNames;
    private String compartmentId;
    private String managedInstanceGroupId;
    private String lifecycleEnvironmentId;
    private String lifecycleStageId;
    private List<ManagedInstanceStatus> status;
    private List<ManagedInstanceLocation> location;
    private List<ManagedInstanceLocation> locationNotEqualTo;
    private List<OsFamily> osFamily;
    private Boolean isManagedByAutonomousLinux;
    private List<String> displayName;
    private String displayNameContains;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;

    public List<MetricName> getMetricNames() {
        return this.metricNames;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getManagedInstanceGroupId() {
        return this.managedInstanceGroupId;
    }

    public String getLifecycleEnvironmentId() {
        return this.lifecycleEnvironmentId;
    }

    public String getLifecycleStageId() {
        return this.lifecycleStageId;
    }

    public List<ManagedInstanceStatus> getStatus() {
        return this.status;
    }

    public List<ManagedInstanceLocation> getLocation() {
        return this.location;
    }

    public List<ManagedInstanceLocation> getLocationNotEqualTo() {
        return this.locationNotEqualTo;
    }

    public List<OsFamily> getOsFamily() {
        return this.osFamily;
    }

    public Boolean getIsManagedByAutonomousLinux() {
        return this.isManagedByAutonomousLinux;
    }

    public List<String> getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().metricNames(this.metricNames).compartmentId(this.compartmentId).managedInstanceGroupId(this.managedInstanceGroupId).lifecycleEnvironmentId(this.lifecycleEnvironmentId).lifecycleStageId(this.lifecycleStageId).status(this.status).location(this.location).locationNotEqualTo(this.locationNotEqualTo).osFamily(this.osFamily).isManagedByAutonomousLinux(this.isManagedByAutonomousLinux).displayName(this.displayName).displayNameContains(this.displayNameContains).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",metricNames=").append(String.valueOf(this.metricNames));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",managedInstanceGroupId=").append(String.valueOf(this.managedInstanceGroupId));
        sb.append(",lifecycleEnvironmentId=").append(String.valueOf(this.lifecycleEnvironmentId));
        sb.append(",lifecycleStageId=").append(String.valueOf(this.lifecycleStageId));
        sb.append(",status=").append(String.valueOf(this.status));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",locationNotEqualTo=").append(String.valueOf(this.locationNotEqualTo));
        sb.append(",osFamily=").append(String.valueOf(this.osFamily));
        sb.append(",isManagedByAutonomousLinux=").append(String.valueOf(this.isManagedByAutonomousLinux));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeManagedInstanceAnalyticsRequest)) {
            return false;
        }
        SummarizeManagedInstanceAnalyticsRequest other = (SummarizeManagedInstanceAnalyticsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.metricNames, other.metricNames) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.managedInstanceGroupId, other.managedInstanceGroupId) && Objects.equals(this.lifecycleEnvironmentId, other.lifecycleEnvironmentId) && Objects.equals(this.lifecycleStageId, other.lifecycleStageId) && Objects.equals(this.status, other.status) && Objects.equals(this.location, other.location) && Objects.equals(this.locationNotEqualTo, other.locationNotEqualTo) && Objects.equals(this.osFamily, other.osFamily) && Objects.equals(this.isManagedByAutonomousLinux, other.isManagedByAutonomousLinux) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.metricNames == null ? 43 : this.metricNames.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.managedInstanceGroupId == null ? 43 : this.managedInstanceGroupId.hashCode());
        result = result * 59 + (this.lifecycleEnvironmentId == null ? 43 : this.lifecycleEnvironmentId.hashCode());
        result = result * 59 + (this.lifecycleStageId == null ? 43 : this.lifecycleStageId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.locationNotEqualTo == null ? 43 : this.locationNotEqualTo.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.isManagedByAutonomousLinux == null ? 43 : this.isManagedByAutonomousLinux.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeManagedInstanceAnalyticsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private List<MetricName> metricNames = null;
        private String compartmentId = null;
        private String managedInstanceGroupId = null;
        private String lifecycleEnvironmentId = null;
        private String lifecycleStageId = null;
        private List<ManagedInstanceStatus> status = null;
        private List<ManagedInstanceLocation> location = null;
        private List<ManagedInstanceLocation> locationNotEqualTo = null;
        private List<OsFamily> osFamily = null;
        private Boolean isManagedByAutonomousLinux = null;
        private List<String> displayName = null;
        private String displayNameContains = null;
        private Integer limit = null;
        private String page = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;

        public Builder metricNames(List<MetricName> metricNames) {
            this.metricNames = metricNames;
            return this;
        }

        public Builder metricNames(MetricName singularValue) {
            return this.metricNames(Arrays.asList(singularValue));
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder managedInstanceGroupId(String managedInstanceGroupId) {
            this.managedInstanceGroupId = managedInstanceGroupId;
            return this;
        }

        public Builder lifecycleEnvironmentId(String lifecycleEnvironmentId) {
            this.lifecycleEnvironmentId = lifecycleEnvironmentId;
            return this;
        }

        public Builder lifecycleStageId(String lifecycleStageId) {
            this.lifecycleStageId = lifecycleStageId;
            return this;
        }

        public Builder status(List<ManagedInstanceStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(ManagedInstanceStatus singularValue) {
            return this.status(Arrays.asList(singularValue));
        }

        public Builder location(List<ManagedInstanceLocation> location) {
            this.location = location;
            return this;
        }

        public Builder location(ManagedInstanceLocation singularValue) {
            return this.location(Arrays.asList(singularValue));
        }

        public Builder locationNotEqualTo(List<ManagedInstanceLocation> locationNotEqualTo) {
            this.locationNotEqualTo = locationNotEqualTo;
            return this;
        }

        public Builder locationNotEqualTo(ManagedInstanceLocation singularValue) {
            return this.locationNotEqualTo(Arrays.asList(singularValue));
        }

        public Builder osFamily(List<OsFamily> osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder osFamily(OsFamily singularValue) {
            return this.osFamily(Arrays.asList(singularValue));
        }

        public Builder isManagedByAutonomousLinux(Boolean isManagedByAutonomousLinux) {
            this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
            return this;
        }

        public Builder displayName(List<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayName(String singularValue) {
            return this.displayName(Arrays.asList(singularValue));
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeManagedInstanceAnalyticsRequest o) {
            this.metricNames(o.getMetricNames());
            this.compartmentId(o.getCompartmentId());
            this.managedInstanceGroupId(o.getManagedInstanceGroupId());
            this.lifecycleEnvironmentId(o.getLifecycleEnvironmentId());
            this.lifecycleStageId(o.getLifecycleStageId());
            this.status(o.getStatus());
            this.location(o.getLocation());
            this.locationNotEqualTo(o.getLocationNotEqualTo());
            this.osFamily(o.getOsFamily());
            this.isManagedByAutonomousLinux(o.getIsManagedByAutonomousLinux());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeManagedInstanceAnalyticsRequest build() {
            SummarizeManagedInstanceAnalyticsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeManagedInstanceAnalyticsRequest buildWithoutInvocationCallback() {
            SummarizeManagedInstanceAnalyticsRequest request = new SummarizeManagedInstanceAnalyticsRequest();
            request.metricNames = this.metricNames;
            request.compartmentId = this.compartmentId;
            request.managedInstanceGroupId = this.managedInstanceGroupId;
            request.lifecycleEnvironmentId = this.lifecycleEnvironmentId;
            request.lifecycleStageId = this.lifecycleStageId;
            request.status = this.status;
            request.location = this.location;
            request.locationNotEqualTo = this.locationNotEqualTo;
            request.osFamily = this.osFamily;
            request.isManagedByAutonomousLinux = this.isManagedByAutonomousLinux;
            request.displayName = this.displayName;
            request.displayNameContains = this.displayNameContains;
            request.limit = this.limit;
            request.page = this.page;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Name("name"),
        MetricName("metricName"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

