/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.osmanagementhub.model.UpdateManagedInstanceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateManagedInstanceRequest
extends BmcRequest<UpdateManagedInstanceDetails> {
    private String managedInstanceId;
    private UpdateManagedInstanceDetails updateManagedInstanceDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public UpdateManagedInstanceDetails getUpdateManagedInstanceDetails() {
        return this.updateManagedInstanceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateManagedInstanceDetails getBody$() {
        return this.updateManagedInstanceDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedInstanceId(this.managedInstanceId).updateManagedInstanceDetails(this.updateManagedInstanceDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",updateManagedInstanceDetails=").append(String.valueOf((Object)this.updateManagedInstanceDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateManagedInstanceRequest)) {
            return false;
        }
        UpdateManagedInstanceRequest other = (UpdateManagedInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals((Object)this.updateManagedInstanceDetails, (Object)other.updateManagedInstanceDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.updateManagedInstanceDetails == null ? 43 : this.updateManagedInstanceDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateManagedInstanceRequest, UpdateManagedInstanceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedInstanceId = null;
        private UpdateManagedInstanceDetails updateManagedInstanceDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder updateManagedInstanceDetails(UpdateManagedInstanceDetails updateManagedInstanceDetails) {
            this.updateManagedInstanceDetails = updateManagedInstanceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateManagedInstanceRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.updateManagedInstanceDetails(o.getUpdateManagedInstanceDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateManagedInstanceRequest build() {
            UpdateManagedInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateManagedInstanceDetails body) {
            this.updateManagedInstanceDetails(body);
            return this;
        }

        public UpdateManagedInstanceRequest buildWithoutInvocationCallback() {
            UpdateManagedInstanceRequest request = new UpdateManagedInstanceRequest();
            request.managedInstanceId = this.managedInstanceId;
            request.updateManagedInstanceDetails = this.updateManagedInstanceDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

