/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.osmanagementhub.model.UpdateProfileDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateProfileRequest
extends BmcRequest<UpdateProfileDetails> {
    private String profileId;
    private UpdateProfileDetails updateProfileDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getProfileId() {
        return this.profileId;
    }

    public UpdateProfileDetails getUpdateProfileDetails() {
        return this.updateProfileDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateProfileDetails getBody$() {
        return this.updateProfileDetails;
    }

    public Builder toBuilder() {
        return new Builder().profileId(this.profileId).updateProfileDetails(this.updateProfileDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",profileId=").append(String.valueOf(this.profileId));
        sb.append(",updateProfileDetails=").append(String.valueOf((Object)this.updateProfileDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateProfileRequest)) {
            return false;
        }
        UpdateProfileRequest other = (UpdateProfileRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.profileId, other.profileId) && Objects.equals((Object)this.updateProfileDetails, (Object)other.updateProfileDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.profileId == null ? 43 : this.profileId.hashCode());
        result = result * 59 + (this.updateProfileDetails == null ? 43 : this.updateProfileDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateProfileRequest, UpdateProfileDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String profileId = null;
        private UpdateProfileDetails updateProfileDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public Builder updateProfileDetails(UpdateProfileDetails updateProfileDetails) {
            this.updateProfileDetails = updateProfileDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateProfileRequest o) {
            this.profileId(o.getProfileId());
            this.updateProfileDetails(o.getUpdateProfileDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateProfileRequest build() {
            UpdateProfileRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateProfileDetails body) {
            this.updateProfileDetails(body);
            return this;
        }

        public UpdateProfileRequest buildWithoutInvocationCallback() {
            UpdateProfileRequest request = new UpdateProfileRequest();
            request.profileId = this.profileId;
            request.updateProfileDetails = this.updateProfileDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

