/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.ospgateway.model.AddressTypeRule;
import com.oracle.bmc.ospgateway.model.ContactTypeRule;
import com.oracle.bmc.ospgateway.model.TaxTypeRule;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AddressRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="countryCode")
    private final String countryCode;
    @JsonProperty(value="address")
    private final AddressTypeRule address;
    @JsonProperty(value="contact")
    private final ContactTypeRule contact;
    @JsonProperty(value="tax")
    private final TaxTypeRule tax;

    @Deprecated
    @ConstructorProperties(value={"countryCode", "address", "contact", "tax"})
    public AddressRule(String countryCode, AddressTypeRule address, ContactTypeRule contact, TaxTypeRule tax) {
        this.countryCode = countryCode;
        this.address = address;
        this.contact = contact;
        this.tax = tax;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public AddressTypeRule getAddress() {
        return this.address;
    }

    public ContactTypeRule getContact() {
        return this.contact;
    }

    public TaxTypeRule getTax() {
        return this.tax;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AddressRule(");
        sb.append("super=").append(super.toString());
        sb.append("countryCode=").append(String.valueOf(this.countryCode));
        sb.append(", address=").append(String.valueOf((Object)this.address));
        sb.append(", contact=").append(String.valueOf((Object)this.contact));
        sb.append(", tax=").append(String.valueOf((Object)this.tax));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddressRule)) {
            return false;
        }
        AddressRule other = (AddressRule)((Object)o);
        return Objects.equals(this.countryCode, other.countryCode) && Objects.equals((Object)this.address, (Object)other.address) && Objects.equals((Object)this.contact, (Object)other.contact) && Objects.equals((Object)this.tax, (Object)other.tax) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.countryCode == null ? 43 : this.countryCode.hashCode());
        result = result * 59 + (this.address == null ? 43 : this.address.hashCode());
        result = result * 59 + (this.contact == null ? 43 : this.contact.hashCode());
        result = result * 59 + (this.tax == null ? 43 : this.tax.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="countryCode")
        private String countryCode;
        @JsonProperty(value="address")
        private AddressTypeRule address;
        @JsonProperty(value="contact")
        private ContactTypeRule contact;
        @JsonProperty(value="tax")
        private TaxTypeRule tax;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            this.__explicitlySet__.add("countryCode");
            return this;
        }

        public Builder address(AddressTypeRule address) {
            this.address = address;
            this.__explicitlySet__.add("address");
            return this;
        }

        public Builder contact(ContactTypeRule contact) {
            this.contact = contact;
            this.__explicitlySet__.add("contact");
            return this;
        }

        public Builder tax(TaxTypeRule tax) {
            this.tax = tax;
            this.__explicitlySet__.add("tax");
            return this;
        }

        public AddressRule build() {
            AddressRule model = new AddressRule(this.countryCode, this.address, this.contact, this.tax);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AddressRule model) {
            if (model.wasPropertyExplicitlySet("countryCode")) {
                this.countryCode(model.getCountryCode());
            }
            if (model.wasPropertyExplicitlySet("address")) {
                this.address(model.getAddress());
            }
            if (model.wasPropertyExplicitlySet("contact")) {
                this.contact(model.getContact());
            }
            if (model.wasPropertyExplicitlySet("tax")) {
                this.tax(model.getTax());
            }
            return this;
        }
    }
}

