/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Currency
extends ExplicitlySetBmcModel {
    @JsonProperty(value="currencyCode")
    private final String currencyCode;
    @JsonProperty(value="currencySymbol")
    private final String currencySymbol;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="usdConversion")
    private final BigDecimal usdConversion;
    @JsonProperty(value="roundDecimalPoint")
    private final BigDecimal roundDecimalPoint;

    @Deprecated
    @ConstructorProperties(value={"currencyCode", "currencySymbol", "name", "usdConversion", "roundDecimalPoint"})
    public Currency(String currencyCode, String currencySymbol, String name, BigDecimal usdConversion, BigDecimal roundDecimalPoint) {
        this.currencyCode = currencyCode;
        this.currencySymbol = currencySymbol;
        this.name = name;
        this.usdConversion = usdConversion;
        this.roundDecimalPoint = roundDecimalPoint;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getUsdConversion() {
        return this.usdConversion;
    }

    public BigDecimal getRoundDecimalPoint() {
        return this.roundDecimalPoint;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Currency(");
        sb.append("super=").append(super.toString());
        sb.append("currencyCode=").append(String.valueOf(this.currencyCode));
        sb.append(", currencySymbol=").append(String.valueOf(this.currencySymbol));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", usdConversion=").append(String.valueOf(this.usdConversion));
        sb.append(", roundDecimalPoint=").append(String.valueOf(this.roundDecimalPoint));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Currency)) {
            return false;
        }
        Currency other = (Currency)((Object)o);
        return Objects.equals(this.currencyCode, other.currencyCode) && Objects.equals(this.currencySymbol, other.currencySymbol) && Objects.equals(this.name, other.name) && Objects.equals(this.usdConversion, other.usdConversion) && Objects.equals(this.roundDecimalPoint, other.roundDecimalPoint) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.currencyCode == null ? 43 : this.currencyCode.hashCode());
        result = result * 59 + (this.currencySymbol == null ? 43 : this.currencySymbol.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.usdConversion == null ? 43 : this.usdConversion.hashCode());
        result = result * 59 + (this.roundDecimalPoint == null ? 43 : this.roundDecimalPoint.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="currencyCode")
        private String currencyCode;
        @JsonProperty(value="currencySymbol")
        private String currencySymbol;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="usdConversion")
        private BigDecimal usdConversion;
        @JsonProperty(value="roundDecimalPoint")
        private BigDecimal roundDecimalPoint;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.__explicitlySet__.add("currencyCode");
            return this;
        }

        public Builder currencySymbol(String currencySymbol) {
            this.currencySymbol = currencySymbol;
            this.__explicitlySet__.add("currencySymbol");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder usdConversion(BigDecimal usdConversion) {
            this.usdConversion = usdConversion;
            this.__explicitlySet__.add("usdConversion");
            return this;
        }

        public Builder roundDecimalPoint(BigDecimal roundDecimalPoint) {
            this.roundDecimalPoint = roundDecimalPoint;
            this.__explicitlySet__.add("roundDecimalPoint");
            return this;
        }

        public Currency build() {
            Currency model = new Currency(this.currencyCode, this.currencySymbol, this.name, this.usdConversion, this.roundDecimalPoint);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Currency model) {
            if (model.wasPropertyExplicitlySet("currencyCode")) {
                this.currencyCode(model.getCurrencyCode());
            }
            if (model.wasPropertyExplicitlySet("currencySymbol")) {
                this.currencySymbol(model.getCurrencySymbol());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("usdConversion")) {
                this.usdConversion(model.getUsdConversion());
            }
            if (model.wasPropertyExplicitlySet("roundDecimalPoint")) {
                this.roundDecimalPoint(model.getRoundDecimalPoint());
            }
            return this;
        }
    }
}

