/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.ospgateway.model.Subscription;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PaySubscriptionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="subscription")
    private final Subscription subscription;
    @JsonProperty(value="languageCode")
    private final String languageCode;
    @JsonProperty(value="email")
    private final String email;

    @Deprecated
    @ConstructorProperties(value={"subscription", "languageCode", "email"})
    public PaySubscriptionDetails(Subscription subscription, String languageCode, String email) {
        this.subscription = subscription;
        this.languageCode = languageCode;
        this.email = email;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PaySubscriptionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("subscription=").append(String.valueOf((Object)this.subscription));
        sb.append(", languageCode=").append(String.valueOf(this.languageCode));
        sb.append(", email=").append(String.valueOf(this.email));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PaySubscriptionDetails)) {
            return false;
        }
        PaySubscriptionDetails other = (PaySubscriptionDetails)((Object)o);
        return Objects.equals((Object)this.subscription, (Object)other.subscription) && Objects.equals(this.languageCode, other.languageCode) && Objects.equals(this.email, other.email) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.subscription == null ? 43 : this.subscription.hashCode());
        result = result * 59 + (this.languageCode == null ? 43 : this.languageCode.hashCode());
        result = result * 59 + (this.email == null ? 43 : this.email.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="subscription")
        private Subscription subscription;
        @JsonProperty(value="languageCode")
        private String languageCode;
        @JsonProperty(value="email")
        private String email;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder subscription(Subscription subscription) {
            this.subscription = subscription;
            this.__explicitlySet__.add("subscription");
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            this.__explicitlySet__.add("languageCode");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.__explicitlySet__.add("email");
            return this;
        }

        public PaySubscriptionDetails build() {
            PaySubscriptionDetails model = new PaySubscriptionDetails(this.subscription, this.languageCode, this.email);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PaySubscriptionDetails model) {
            if (model.wasPropertyExplicitlySet("subscription")) {
                this.subscription(model.getSubscription());
            }
            if (model.wasPropertyExplicitlySet("languageCode")) {
                this.languageCode(model.getLanguageCode());
            }
            if (model.wasPropertyExplicitlySet("email")) {
                this.email(model.getEmail());
            }
            return this;
        }
    }
}

