/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ospgateway.model.PaymentDetail;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="paymentMethod")
@JsonFilter(value="explicitlySetFilter")
public final class PaypalPaymentDetail
extends PaymentDetail {
    @JsonProperty(value="paypalId")
    private final String paypalId;
    @JsonProperty(value="paypalReference")
    private final String paypalReference;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PaypalPaymentDetail(Date timePaidOn, String paidBy, BigDecimal amountPaid, String paypalId, String paypalReference) {
        super(timePaidOn, paidBy, amountPaid);
        this.paypalId = paypalId;
        this.paypalReference = paypalReference;
    }

    public String getPaypalId() {
        return this.paypalId;
    }

    public String getPaypalReference() {
        return this.paypalReference;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PaypalPaymentDetail(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", paypalId=").append(String.valueOf(this.paypalId));
        sb.append(", paypalReference=").append(String.valueOf(this.paypalReference));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PaypalPaymentDetail)) {
            return false;
        }
        PaypalPaymentDetail other = (PaypalPaymentDetail)((Object)o);
        return Objects.equals(this.paypalId, other.paypalId) && Objects.equals(this.paypalReference, other.paypalReference) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.paypalId == null ? 43 : this.paypalId.hashCode());
        result = result * 59 + (this.paypalReference == null ? 43 : this.paypalReference.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timePaidOn")
        private Date timePaidOn;
        @JsonProperty(value="paidBy")
        private String paidBy;
        @JsonProperty(value="amountPaid")
        private BigDecimal amountPaid;
        @JsonProperty(value="paypalId")
        private String paypalId;
        @JsonProperty(value="paypalReference")
        private String paypalReference;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timePaidOn(Date timePaidOn) {
            this.timePaidOn = timePaidOn;
            this.__explicitlySet__.add("timePaidOn");
            return this;
        }

        public Builder paidBy(String paidBy) {
            this.paidBy = paidBy;
            this.__explicitlySet__.add("paidBy");
            return this;
        }

        public Builder amountPaid(BigDecimal amountPaid) {
            this.amountPaid = amountPaid;
            this.__explicitlySet__.add("amountPaid");
            return this;
        }

        public Builder paypalId(String paypalId) {
            this.paypalId = paypalId;
            this.__explicitlySet__.add("paypalId");
            return this;
        }

        public Builder paypalReference(String paypalReference) {
            this.paypalReference = paypalReference;
            this.__explicitlySet__.add("paypalReference");
            return this;
        }

        public PaypalPaymentDetail build() {
            PaypalPaymentDetail model = new PaypalPaymentDetail(this.timePaidOn, this.paidBy, this.amountPaid, this.paypalId, this.paypalReference);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PaypalPaymentDetail model) {
            if (model.wasPropertyExplicitlySet("timePaidOn")) {
                this.timePaidOn(model.getTimePaidOn());
            }
            if (model.wasPropertyExplicitlySet("paidBy")) {
                this.paidBy(model.getPaidBy());
            }
            if (model.wasPropertyExplicitlySet("amountPaid")) {
                this.amountPaid(model.getAmountPaid());
            }
            if (model.wasPropertyExplicitlySet("paypalId")) {
                this.paypalId(model.getPaypalId());
            }
            if (model.wasPropertyExplicitlySet("paypalReference")) {
                this.paypalReference(model.getPaypalReference());
            }
            return this;
        }
    }
}

