/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TaxInfo
extends ExplicitlySetBmcModel {
    @JsonProperty(value="taxPayerId")
    private final String taxPayerId;
    @JsonProperty(value="taxRegNumber")
    private final String taxRegNumber;
    @JsonProperty(value="noTaxReasonCode")
    private final String noTaxReasonCode;
    @JsonProperty(value="noTaxReasonCodeDetails")
    private final String noTaxReasonCodeDetails;
    @JsonProperty(value="taxCnpj")
    private final String taxCnpj;
    @JsonProperty(value="giro")
    private final String giro;

    @Deprecated
    @ConstructorProperties(value={"taxPayerId", "taxRegNumber", "noTaxReasonCode", "noTaxReasonCodeDetails", "taxCnpj", "giro"})
    public TaxInfo(String taxPayerId, String taxRegNumber, String noTaxReasonCode, String noTaxReasonCodeDetails, String taxCnpj, String giro) {
        this.taxPayerId = taxPayerId;
        this.taxRegNumber = taxRegNumber;
        this.noTaxReasonCode = noTaxReasonCode;
        this.noTaxReasonCodeDetails = noTaxReasonCodeDetails;
        this.taxCnpj = taxCnpj;
        this.giro = giro;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTaxPayerId() {
        return this.taxPayerId;
    }

    public String getTaxRegNumber() {
        return this.taxRegNumber;
    }

    public String getNoTaxReasonCode() {
        return this.noTaxReasonCode;
    }

    public String getNoTaxReasonCodeDetails() {
        return this.noTaxReasonCodeDetails;
    }

    public String getTaxCnpj() {
        return this.taxCnpj;
    }

    public String getGiro() {
        return this.giro;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TaxInfo(");
        sb.append("super=").append(super.toString());
        sb.append("taxPayerId=").append(String.valueOf(this.taxPayerId));
        sb.append(", taxRegNumber=").append(String.valueOf(this.taxRegNumber));
        sb.append(", noTaxReasonCode=").append(String.valueOf(this.noTaxReasonCode));
        sb.append(", noTaxReasonCodeDetails=").append(String.valueOf(this.noTaxReasonCodeDetails));
        sb.append(", taxCnpj=").append(String.valueOf(this.taxCnpj));
        sb.append(", giro=").append(String.valueOf(this.giro));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaxInfo)) {
            return false;
        }
        TaxInfo other = (TaxInfo)((Object)o);
        return Objects.equals(this.taxPayerId, other.taxPayerId) && Objects.equals(this.taxRegNumber, other.taxRegNumber) && Objects.equals(this.noTaxReasonCode, other.noTaxReasonCode) && Objects.equals(this.noTaxReasonCodeDetails, other.noTaxReasonCodeDetails) && Objects.equals(this.taxCnpj, other.taxCnpj) && Objects.equals(this.giro, other.giro) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.taxPayerId == null ? 43 : this.taxPayerId.hashCode());
        result = result * 59 + (this.taxRegNumber == null ? 43 : this.taxRegNumber.hashCode());
        result = result * 59 + (this.noTaxReasonCode == null ? 43 : this.noTaxReasonCode.hashCode());
        result = result * 59 + (this.noTaxReasonCodeDetails == null ? 43 : this.noTaxReasonCodeDetails.hashCode());
        result = result * 59 + (this.taxCnpj == null ? 43 : this.taxCnpj.hashCode());
        result = result * 59 + (this.giro == null ? 43 : this.giro.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="taxPayerId")
        private String taxPayerId;
        @JsonProperty(value="taxRegNumber")
        private String taxRegNumber;
        @JsonProperty(value="noTaxReasonCode")
        private String noTaxReasonCode;
        @JsonProperty(value="noTaxReasonCodeDetails")
        private String noTaxReasonCodeDetails;
        @JsonProperty(value="taxCnpj")
        private String taxCnpj;
        @JsonProperty(value="giro")
        private String giro;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder taxPayerId(String taxPayerId) {
            this.taxPayerId = taxPayerId;
            this.__explicitlySet__.add("taxPayerId");
            return this;
        }

        public Builder taxRegNumber(String taxRegNumber) {
            this.taxRegNumber = taxRegNumber;
            this.__explicitlySet__.add("taxRegNumber");
            return this;
        }

        public Builder noTaxReasonCode(String noTaxReasonCode) {
            this.noTaxReasonCode = noTaxReasonCode;
            this.__explicitlySet__.add("noTaxReasonCode");
            return this;
        }

        public Builder noTaxReasonCodeDetails(String noTaxReasonCodeDetails) {
            this.noTaxReasonCodeDetails = noTaxReasonCodeDetails;
            this.__explicitlySet__.add("noTaxReasonCodeDetails");
            return this;
        }

        public Builder taxCnpj(String taxCnpj) {
            this.taxCnpj = taxCnpj;
            this.__explicitlySet__.add("taxCnpj");
            return this;
        }

        public Builder giro(String giro) {
            this.giro = giro;
            this.__explicitlySet__.add("giro");
            return this;
        }

        public TaxInfo build() {
            TaxInfo model = new TaxInfo(this.taxPayerId, this.taxRegNumber, this.noTaxReasonCode, this.noTaxReasonCodeDetails, this.taxCnpj, this.giro);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TaxInfo model) {
            if (model.wasPropertyExplicitlySet("taxPayerId")) {
                this.taxPayerId(model.getTaxPayerId());
            }
            if (model.wasPropertyExplicitlySet("taxRegNumber")) {
                this.taxRegNumber(model.getTaxRegNumber());
            }
            if (model.wasPropertyExplicitlySet("noTaxReasonCode")) {
                this.noTaxReasonCode(model.getNoTaxReasonCode());
            }
            if (model.wasPropertyExplicitlySet("noTaxReasonCodeDetails")) {
                this.noTaxReasonCodeDetails(model.getNoTaxReasonCodeDetails());
            }
            if (model.wasPropertyExplicitlySet("taxCnpj")) {
                this.taxCnpj(model.getTaxCnpj());
            }
            if (model.wasPropertyExplicitlySet("giro")) {
                this.giro(model.getGiro());
            }
            return this;
        }
    }
}

