/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.ospgateway.model.UpdateSubscriptionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSubscriptionRequest
extends BmcRequest<UpdateSubscriptionDetails> {
    private String subscriptionId;
    private String ospHomeRegion;
    private String compartmentId;
    private UpdateSubscriptionDetails updateSubscriptionDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getOspHomeRegion() {
        return this.ospHomeRegion;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public UpdateSubscriptionDetails getUpdateSubscriptionDetails() {
        return this.updateSubscriptionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateSubscriptionDetails getBody$() {
        return this.updateSubscriptionDetails;
    }

    public Builder toBuilder() {
        return new Builder().subscriptionId(this.subscriptionId).ospHomeRegion(this.ospHomeRegion).compartmentId(this.compartmentId).updateSubscriptionDetails(this.updateSubscriptionDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(",ospHomeRegion=").append(String.valueOf(this.ospHomeRegion));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",updateSubscriptionDetails=").append(String.valueOf((Object)this.updateSubscriptionDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSubscriptionRequest)) {
            return false;
        }
        UpdateSubscriptionRequest other = (UpdateSubscriptionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.ospHomeRegion, other.ospHomeRegion) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.updateSubscriptionDetails, (Object)other.updateSubscriptionDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.ospHomeRegion == null ? 43 : this.ospHomeRegion.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.updateSubscriptionDetails == null ? 43 : this.updateSubscriptionDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSubscriptionRequest, UpdateSubscriptionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String subscriptionId = null;
        private String ospHomeRegion = null;
        private String compartmentId = null;
        private UpdateSubscriptionDetails updateSubscriptionDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder ospHomeRegion(String ospHomeRegion) {
            this.ospHomeRegion = ospHomeRegion;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder updateSubscriptionDetails(UpdateSubscriptionDetails updateSubscriptionDetails) {
            this.updateSubscriptionDetails = updateSubscriptionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSubscriptionRequest o) {
            this.subscriptionId(o.getSubscriptionId());
            this.ospHomeRegion(o.getOspHomeRegion());
            this.compartmentId(o.getCompartmentId());
            this.updateSubscriptionDetails(o.getUpdateSubscriptionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSubscriptionRequest build() {
            UpdateSubscriptionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSubscriptionDetails body) {
            this.updateSubscriptionDetails(body);
            return this;
        }

        public UpdateSubscriptionRequest buildWithoutInvocationCallback() {
            UpdateSubscriptionRequest request = new UpdateSubscriptionRequest();
            request.subscriptionId = this.subscriptionId;
            request.ospHomeRegion = this.ospHomeRegion;
            request.compartmentId = this.compartmentId;
            request.updateSubscriptionDetails = this.updateSubscriptionDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

