/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.ospgateway.AddressService;
import com.oracle.bmc.ospgateway.model.Address;
import com.oracle.bmc.ospgateway.model.VerifyAddressReceipt;
import com.oracle.bmc.ospgateway.requests.GetAddressRequest;
import com.oracle.bmc.ospgateway.requests.VerifyAddressRequest;
import com.oracle.bmc.ospgateway.responses.GetAddressResponse;
import com.oracle.bmc.ospgateway.responses.VerifyAddressResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressServiceClient
extends BaseSyncClient
implements AddressService {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ADDRESSSERVICE").serviceEndpointPrefix("").serviceEndpointTemplate("https://osp-oci-integ.osp.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AddressServiceClient.class);

    AddressServiceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public GetAddressResponse getAddress(GetAddressRequest request) {
        Objects.requireNonNull(request.getOspHomeRegion(), "ospHomeRegion is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getAddressId(), (String)"addressId must not be blank", (Object[])new Object[0]);
        return (GetAddressResponse)this.clientCall(request, GetAddressResponse::builder).logger(LOG, "getAddress").serviceDetails("AddressService", "GetAddress", "").method(Method.GET).requestBuilder(GetAddressRequest::builder).basePath("/20191001").appendPathParam("addresses").appendPathParam(request.getAddressId()).appendQueryParam("ospHomeRegion", (Object)request.getOspHomeRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Address.class, GetAddressResponse.Builder::address).handleResponseHeaderString("opc-request-id", GetAddressResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public VerifyAddressResponse verifyAddress(VerifyAddressRequest request) {
        Objects.requireNonNull(request.getOspHomeRegion(), "ospHomeRegion is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getVerifyAddressDetails(), "verifyAddressDetails is required");
        return (VerifyAddressResponse)this.clientCall(request, VerifyAddressResponse::builder).logger(LOG, "verifyAddress").serviceDetails("AddressService", "VerifyAddress", "").method(Method.POST).requestBuilder(VerifyAddressRequest::builder).basePath("/20191001").appendPathParam("addresses").appendPathParam("action").appendPathParam("verification").appendQueryParam("ospHomeRegion", (Object)request.getOspHomeRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(VerifyAddressReceipt.class, VerifyAddressResponse.Builder::verifyAddressReceipt).handleResponseHeaderString("opc-request-id", VerifyAddressResponse.Builder::opcRequestId).handleResponseHeaderString("etag", VerifyAddressResponse.Builder::etag).callSync();
    }

    @Deprecated
    public AddressServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AddressServiceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AddressServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AddressServiceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AddressServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AddressServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AddressServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AddressServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AddressServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AddressServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AddressServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AddressServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AddressServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AddressServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AddressServiceClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "ospgateway";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"ospgateway");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AddressServiceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AddressServiceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

