/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.ospgateway.model.PaymentDetail;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="paymentMethod")
@JsonFilter(value="explicitlySetFilter")
public final class EcheckPaymentDetail
extends PaymentDetail {
    @JsonProperty(value="nameOnCard")
    private final String nameOnCard;
    @JsonProperty(value="cardType")
    private final CardType cardType;
    @JsonProperty(value="accountNumber")
    private final String accountNumber;
    @JsonProperty(value="routingNumber")
    private final String routingNumber;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public EcheckPaymentDetail(Date timePaidOn, String paidBy, BigDecimal amountPaid, String nameOnCard, CardType cardType, String accountNumber, String routingNumber) {
        super(timePaidOn, paidBy, amountPaid);
        this.nameOnCard = nameOnCard;
        this.cardType = cardType;
        this.accountNumber = accountNumber;
        this.routingNumber = routingNumber;
    }

    public String getNameOnCard() {
        return this.nameOnCard;
    }

    public CardType getCardType() {
        return this.cardType;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public String getRoutingNumber() {
        return this.routingNumber;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EcheckPaymentDetail(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", nameOnCard=").append(String.valueOf(this.nameOnCard));
        sb.append(", cardType=").append(String.valueOf((Object)this.cardType));
        sb.append(", accountNumber=").append(String.valueOf(this.accountNumber));
        sb.append(", routingNumber=").append(String.valueOf(this.routingNumber));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EcheckPaymentDetail)) {
            return false;
        }
        EcheckPaymentDetail other = (EcheckPaymentDetail)((Object)o);
        return Objects.equals(this.nameOnCard, other.nameOnCard) && Objects.equals((Object)this.cardType, (Object)other.cardType) && Objects.equals(this.accountNumber, other.accountNumber) && Objects.equals(this.routingNumber, other.routingNumber) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.nameOnCard == null ? 43 : this.nameOnCard.hashCode());
        result = result * 59 + (this.cardType == null ? 43 : this.cardType.hashCode());
        result = result * 59 + (this.accountNumber == null ? 43 : this.accountNumber.hashCode());
        result = result * 59 + (this.routingNumber == null ? 43 : this.routingNumber.hashCode());
        return result;
    }

    public static enum CardType implements BmcEnum
    {
        Saving("SAVING"),
        Checking("CHECKING"),
        CorporateChecking("CORPORATE_CHECKING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CardType> map;

        private CardType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CardType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CardType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CardType.class);
            map = new HashMap<String, CardType>();
            for (CardType v : CardType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timePaidOn")
        private Date timePaidOn;
        @JsonProperty(value="paidBy")
        private String paidBy;
        @JsonProperty(value="amountPaid")
        private BigDecimal amountPaid;
        @JsonProperty(value="nameOnCard")
        private String nameOnCard;
        @JsonProperty(value="cardType")
        private CardType cardType;
        @JsonProperty(value="accountNumber")
        private String accountNumber;
        @JsonProperty(value="routingNumber")
        private String routingNumber;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timePaidOn(Date timePaidOn) {
            this.timePaidOn = timePaidOn;
            this.__explicitlySet__.add("timePaidOn");
            return this;
        }

        public Builder paidBy(String paidBy) {
            this.paidBy = paidBy;
            this.__explicitlySet__.add("paidBy");
            return this;
        }

        public Builder amountPaid(BigDecimal amountPaid) {
            this.amountPaid = amountPaid;
            this.__explicitlySet__.add("amountPaid");
            return this;
        }

        public Builder nameOnCard(String nameOnCard) {
            this.nameOnCard = nameOnCard;
            this.__explicitlySet__.add("nameOnCard");
            return this;
        }

        public Builder cardType(CardType cardType) {
            this.cardType = cardType;
            this.__explicitlySet__.add("cardType");
            return this;
        }

        public Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            this.__explicitlySet__.add("accountNumber");
            return this;
        }

        public Builder routingNumber(String routingNumber) {
            this.routingNumber = routingNumber;
            this.__explicitlySet__.add("routingNumber");
            return this;
        }

        public EcheckPaymentDetail build() {
            EcheckPaymentDetail model = new EcheckPaymentDetail(this.timePaidOn, this.paidBy, this.amountPaid, this.nameOnCard, this.cardType, this.accountNumber, this.routingNumber);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EcheckPaymentDetail model) {
            if (model.wasPropertyExplicitlySet("timePaidOn")) {
                this.timePaidOn(model.getTimePaidOn());
            }
            if (model.wasPropertyExplicitlySet("paidBy")) {
                this.paidBy(model.getPaidBy());
            }
            if (model.wasPropertyExplicitlySet("amountPaid")) {
                this.amountPaid(model.getAmountPaid());
            }
            if (model.wasPropertyExplicitlySet("nameOnCard")) {
                this.nameOnCard(model.getNameOnCard());
            }
            if (model.wasPropertyExplicitlySet("cardType")) {
                this.cardType(model.getCardType());
            }
            if (model.wasPropertyExplicitlySet("accountNumber")) {
                this.accountNumber(model.getAccountNumber());
            }
            if (model.wasPropertyExplicitlySet("routingNumber")) {
                this.routingNumber(model.getRoutingNumber());
            }
            return this;
        }
    }
}

