/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.ospgateway.model.Address;
import com.oracle.bmc.ospgateway.model.AddressQualityType;
import com.oracle.bmc.ospgateway.model.AddressVerificationCode;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VerifyAddressReceipt
extends ExplicitlySetBmcModel {
    @JsonProperty(value="address")
    private final Address address;
    @JsonProperty(value="quality")
    private final AddressQualityType quality;
    @JsonProperty(value="verificationCode")
    private final AddressVerificationCode verificationCode;

    @Deprecated
    @ConstructorProperties(value={"address", "quality", "verificationCode"})
    public VerifyAddressReceipt(Address address, AddressQualityType quality, AddressVerificationCode verificationCode) {
        this.address = address;
        this.quality = quality;
        this.verificationCode = verificationCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Address getAddress() {
        return this.address;
    }

    public AddressQualityType getQuality() {
        return this.quality;
    }

    public AddressVerificationCode getVerificationCode() {
        return this.verificationCode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VerifyAddressReceipt(");
        sb.append("super=").append(super.toString());
        sb.append("address=").append(String.valueOf((Object)this.address));
        sb.append(", quality=").append(String.valueOf((Object)this.quality));
        sb.append(", verificationCode=").append(String.valueOf((Object)this.verificationCode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VerifyAddressReceipt)) {
            return false;
        }
        VerifyAddressReceipt other = (VerifyAddressReceipt)((Object)o);
        return Objects.equals((Object)this.address, (Object)other.address) && Objects.equals((Object)this.quality, (Object)other.quality) && Objects.equals((Object)this.verificationCode, (Object)other.verificationCode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.address == null ? 43 : this.address.hashCode());
        result = result * 59 + (this.quality == null ? 43 : this.quality.hashCode());
        result = result * 59 + (this.verificationCode == null ? 43 : this.verificationCode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="address")
        private Address address;
        @JsonProperty(value="quality")
        private AddressQualityType quality;
        @JsonProperty(value="verificationCode")
        private AddressVerificationCode verificationCode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder address(Address address) {
            this.address = address;
            this.__explicitlySet__.add("address");
            return this;
        }

        public Builder quality(AddressQualityType quality) {
            this.quality = quality;
            this.__explicitlySet__.add("quality");
            return this;
        }

        public Builder verificationCode(AddressVerificationCode verificationCode) {
            this.verificationCode = verificationCode;
            this.__explicitlySet__.add("verificationCode");
            return this;
        }

        public VerifyAddressReceipt build() {
            VerifyAddressReceipt model = new VerifyAddressReceipt(this.address, this.quality, this.verificationCode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VerifyAddressReceipt model) {
            if (model.wasPropertyExplicitlySet("address")) {
                this.address(model.getAddress());
            }
            if (model.wasPropertyExplicitlySet("quality")) {
                this.quality(model.getQuality());
            }
            if (model.wasPropertyExplicitlySet("verificationCode")) {
                this.verificationCode(model.getVerificationCode());
            }
            return this;
        }
    }
}

