/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListInvoiceLinesRequest
extends BmcRequest<Void> {
    private String ospHomeRegion;
    private String compartmentId;
    private String internalInvoiceId;
    private String opcRequestId;
    private String page;
    private Integer limit;

    public String getOspHomeRegion() {
        return this.ospHomeRegion;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getInternalInvoiceId() {
        return this.internalInvoiceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new Builder().ospHomeRegion(this.ospHomeRegion).compartmentId(this.compartmentId).internalInvoiceId(this.internalInvoiceId).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ospHomeRegion=").append(String.valueOf(this.ospHomeRegion));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",internalInvoiceId=").append(String.valueOf(this.internalInvoiceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListInvoiceLinesRequest)) {
            return false;
        }
        ListInvoiceLinesRequest other = (ListInvoiceLinesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ospHomeRegion, other.ospHomeRegion) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.internalInvoiceId, other.internalInvoiceId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ospHomeRegion == null ? 43 : this.ospHomeRegion.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.internalInvoiceId == null ? 43 : this.internalInvoiceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListInvoiceLinesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ospHomeRegion = null;
        private String compartmentId = null;
        private String internalInvoiceId = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;

        public Builder ospHomeRegion(String ospHomeRegion) {
            this.ospHomeRegion = ospHomeRegion;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder internalInvoiceId(String internalInvoiceId) {
            this.internalInvoiceId = internalInvoiceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListInvoiceLinesRequest o) {
            this.ospHomeRegion(o.getOspHomeRegion());
            this.compartmentId(o.getCompartmentId());
            this.internalInvoiceId(o.getInternalInvoiceId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListInvoiceLinesRequest build() {
            ListInvoiceLinesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListInvoiceLinesRequest buildWithoutInvocationCallback() {
            ListInvoiceLinesRequest request = new ListInvoiceLinesRequest();
            request.ospHomeRegion = this.ospHomeRegion;
            request.compartmentId = this.compartmentId;
            request.internalInvoiceId = this.internalInvoiceId;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            return request;
        }
    }
}

