/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osubbillingschedule;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.osubbillingschedule.BillingSchedule;
import com.oracle.bmc.osubbillingschedule.BillingSchedulePaginators;
import com.oracle.bmc.osubbillingschedule.model.BillingScheduleSummary;
import com.oracle.bmc.osubbillingschedule.requests.ListBillingSchedulesRequest;
import com.oracle.bmc.osubbillingschedule.responses.ListBillingSchedulesResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillingScheduleClient
extends BaseSyncClient
implements BillingSchedule {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BILLINGSCHEDULE").serviceEndpointPrefix("").serviceEndpointTemplate("https://csaap-e.oracle.com").build();
    private static final Logger LOG = LoggerFactory.getLogger(BillingScheduleClient.class);
    private final BillingSchedulePaginators paginators = new BillingSchedulePaginators(this);

    BillingScheduleClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ListBillingSchedulesResponse listBillingSchedules(ListBillingSchedulesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getSubscriptionId(), "subscriptionId is required");
        return (ListBillingSchedulesResponse)this.clientCall(request, ListBillingSchedulesResponse::builder).logger(LOG, "listBillingSchedules").serviceDetails("BillingSchedule", "ListBillingSchedules", "").method(Method.GET).requestBuilder(ListBillingSchedulesRequest::builder).basePath("/oalapp/service/onesubs/proxy/20210501").appendPathParam("billingSchedules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("subscribedServiceId", (Object)request.getSubscribedServiceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("x-one-origin-region", request.getXOneOriginRegion()).handleBodyList(BillingScheduleSummary.class, ListBillingSchedulesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListBillingSchedulesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListBillingSchedulesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BillingSchedulePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public BillingScheduleClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)BillingScheduleClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public BillingScheduleClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(BillingScheduleClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public BillingScheduleClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)BillingScheduleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public BillingScheduleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)BillingScheduleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public BillingScheduleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)BillingScheduleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public BillingScheduleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)BillingScheduleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public BillingScheduleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)BillingScheduleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BillingScheduleClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "osubbillingschedule";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osubbillingschedule");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public BillingScheduleClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new BillingScheduleClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

