/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osubbillingschedule.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osubbillingschedule.model.Product;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BillingScheduleSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="timeInvoicing")
    private final Date timeInvoicing;
    @JsonProperty(value="invoiceStatus")
    private final InvoiceStatus invoiceStatus;
    @JsonProperty(value="quantity")
    private final String quantity;
    @JsonProperty(value="netUnitPrice")
    private final String netUnitPrice;
    @JsonProperty(value="amount")
    private final String amount;
    @JsonProperty(value="billingFrequency")
    private final String billingFrequency;
    @JsonProperty(value="arInvoiceNumber")
    private final String arInvoiceNumber;
    @JsonProperty(value="arCustomerTransactionId")
    private final String arCustomerTransactionId;
    @JsonProperty(value="orderNumber")
    private final String orderNumber;
    @JsonProperty(value="product")
    private final Product product;

    @Deprecated
    @ConstructorProperties(value={"timeStart", "timeEnd", "timeInvoicing", "invoiceStatus", "quantity", "netUnitPrice", "amount", "billingFrequency", "arInvoiceNumber", "arCustomerTransactionId", "orderNumber", "product"})
    public BillingScheduleSummary(Date timeStart, Date timeEnd, Date timeInvoicing, InvoiceStatus invoiceStatus, String quantity, String netUnitPrice, String amount, String billingFrequency, String arInvoiceNumber, String arCustomerTransactionId, String orderNumber, Product product) {
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.timeInvoicing = timeInvoicing;
        this.invoiceStatus = invoiceStatus;
        this.quantity = quantity;
        this.netUnitPrice = netUnitPrice;
        this.amount = amount;
        this.billingFrequency = billingFrequency;
        this.arInvoiceNumber = arInvoiceNumber;
        this.arCustomerTransactionId = arCustomerTransactionId;
        this.orderNumber = orderNumber;
        this.product = product;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Date getTimeInvoicing() {
        return this.timeInvoicing;
    }

    public InvoiceStatus getInvoiceStatus() {
        return this.invoiceStatus;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public String getNetUnitPrice() {
        return this.netUnitPrice;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getBillingFrequency() {
        return this.billingFrequency;
    }

    public String getArInvoiceNumber() {
        return this.arInvoiceNumber;
    }

    public String getArCustomerTransactionId() {
        return this.arCustomerTransactionId;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public Product getProduct() {
        return this.product;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BillingScheduleSummary(");
        sb.append("super=").append(super.toString());
        sb.append("timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", timeInvoicing=").append(String.valueOf(this.timeInvoicing));
        sb.append(", invoiceStatus=").append(String.valueOf((Object)this.invoiceStatus));
        sb.append(", quantity=").append(String.valueOf(this.quantity));
        sb.append(", netUnitPrice=").append(String.valueOf(this.netUnitPrice));
        sb.append(", amount=").append(String.valueOf(this.amount));
        sb.append(", billingFrequency=").append(String.valueOf(this.billingFrequency));
        sb.append(", arInvoiceNumber=").append(String.valueOf(this.arInvoiceNumber));
        sb.append(", arCustomerTransactionId=").append(String.valueOf(this.arCustomerTransactionId));
        sb.append(", orderNumber=").append(String.valueOf(this.orderNumber));
        sb.append(", product=").append(String.valueOf((Object)this.product));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BillingScheduleSummary)) {
            return false;
        }
        BillingScheduleSummary other = (BillingScheduleSummary)((Object)o);
        return Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.timeInvoicing, other.timeInvoicing) && Objects.equals((Object)this.invoiceStatus, (Object)other.invoiceStatus) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.netUnitPrice, other.netUnitPrice) && Objects.equals(this.amount, other.amount) && Objects.equals(this.billingFrequency, other.billingFrequency) && Objects.equals(this.arInvoiceNumber, other.arInvoiceNumber) && Objects.equals(this.arCustomerTransactionId, other.arCustomerTransactionId) && Objects.equals(this.orderNumber, other.orderNumber) && Objects.equals((Object)this.product, (Object)other.product) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.timeInvoicing == null ? 43 : this.timeInvoicing.hashCode());
        result = result * 59 + (this.invoiceStatus == null ? 43 : this.invoiceStatus.hashCode());
        result = result * 59 + (this.quantity == null ? 43 : this.quantity.hashCode());
        result = result * 59 + (this.netUnitPrice == null ? 43 : this.netUnitPrice.hashCode());
        result = result * 59 + (this.amount == null ? 43 : this.amount.hashCode());
        result = result * 59 + (this.billingFrequency == null ? 43 : this.billingFrequency.hashCode());
        result = result * 59 + (this.arInvoiceNumber == null ? 43 : this.arInvoiceNumber.hashCode());
        result = result * 59 + (this.arCustomerTransactionId == null ? 43 : this.arCustomerTransactionId.hashCode());
        result = result * 59 + (this.orderNumber == null ? 43 : this.orderNumber.hashCode());
        result = result * 59 + (this.product == null ? 43 : this.product.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum InvoiceStatus implements BmcEnum
    {
        Invoiced("INVOICED"),
        NotInvoiced("NOT_INVOICED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, InvoiceStatus> map;

        private InvoiceStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InvoiceStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'InvoiceStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(InvoiceStatus.class);
            map = new HashMap<String, InvoiceStatus>();
            for (InvoiceStatus v : InvoiceStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="timeInvoicing")
        private Date timeInvoicing;
        @JsonProperty(value="invoiceStatus")
        private InvoiceStatus invoiceStatus;
        @JsonProperty(value="quantity")
        private String quantity;
        @JsonProperty(value="netUnitPrice")
        private String netUnitPrice;
        @JsonProperty(value="amount")
        private String amount;
        @JsonProperty(value="billingFrequency")
        private String billingFrequency;
        @JsonProperty(value="arInvoiceNumber")
        private String arInvoiceNumber;
        @JsonProperty(value="arCustomerTransactionId")
        private String arCustomerTransactionId;
        @JsonProperty(value="orderNumber")
        private String orderNumber;
        @JsonProperty(value="product")
        private Product product;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder timeInvoicing(Date timeInvoicing) {
            this.timeInvoicing = timeInvoicing;
            this.__explicitlySet__.add("timeInvoicing");
            return this;
        }

        public Builder invoiceStatus(InvoiceStatus invoiceStatus) {
            this.invoiceStatus = invoiceStatus;
            this.__explicitlySet__.add("invoiceStatus");
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            this.__explicitlySet__.add("quantity");
            return this;
        }

        public Builder netUnitPrice(String netUnitPrice) {
            this.netUnitPrice = netUnitPrice;
            this.__explicitlySet__.add("netUnitPrice");
            return this;
        }

        public Builder amount(String amount) {
            this.amount = amount;
            this.__explicitlySet__.add("amount");
            return this;
        }

        public Builder billingFrequency(String billingFrequency) {
            this.billingFrequency = billingFrequency;
            this.__explicitlySet__.add("billingFrequency");
            return this;
        }

        public Builder arInvoiceNumber(String arInvoiceNumber) {
            this.arInvoiceNumber = arInvoiceNumber;
            this.__explicitlySet__.add("arInvoiceNumber");
            return this;
        }

        public Builder arCustomerTransactionId(String arCustomerTransactionId) {
            this.arCustomerTransactionId = arCustomerTransactionId;
            this.__explicitlySet__.add("arCustomerTransactionId");
            return this;
        }

        public Builder orderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            this.__explicitlySet__.add("orderNumber");
            return this;
        }

        public Builder product(Product product) {
            this.product = product;
            this.__explicitlySet__.add("product");
            return this;
        }

        public BillingScheduleSummary build() {
            BillingScheduleSummary model = new BillingScheduleSummary(this.timeStart, this.timeEnd, this.timeInvoicing, this.invoiceStatus, this.quantity, this.netUnitPrice, this.amount, this.billingFrequency, this.arInvoiceNumber, this.arCustomerTransactionId, this.orderNumber, this.product);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BillingScheduleSummary model) {
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("timeInvoicing")) {
                this.timeInvoicing(model.getTimeInvoicing());
            }
            if (model.wasPropertyExplicitlySet("invoiceStatus")) {
                this.invoiceStatus(model.getInvoiceStatus());
            }
            if (model.wasPropertyExplicitlySet("quantity")) {
                this.quantity(model.getQuantity());
            }
            if (model.wasPropertyExplicitlySet("netUnitPrice")) {
                this.netUnitPrice(model.getNetUnitPrice());
            }
            if (model.wasPropertyExplicitlySet("amount")) {
                this.amount(model.getAmount());
            }
            if (model.wasPropertyExplicitlySet("billingFrequency")) {
                this.billingFrequency(model.getBillingFrequency());
            }
            if (model.wasPropertyExplicitlySet("arInvoiceNumber")) {
                this.arInvoiceNumber(model.getArInvoiceNumber());
            }
            if (model.wasPropertyExplicitlySet("arCustomerTransactionId")) {
                this.arCustomerTransactionId(model.getArCustomerTransactionId());
            }
            if (model.wasPropertyExplicitlySet("orderNumber")) {
                this.orderNumber(model.getOrderNumber());
            }
            if (model.wasPropertyExplicitlySet("product")) {
                this.product(model.getProduct());
            }
            return this;
        }
    }
}

