/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osubsubscription;

import com.oracle.bmc.osubsubscription.Ratecard;
import com.oracle.bmc.osubsubscription.model.RateCardSummary;
import com.oracle.bmc.osubsubscription.requests.ListRateCardsRequest;
import com.oracle.bmc.osubsubscription.responses.ListRateCardsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class RatecardPaginators {
    private final Ratecard client;

    public RatecardPaginators(Ratecard client) {
        this.client = client;
    }

    public Iterable<ListRateCardsResponse> listRateCardsResponseIterator(final ListRateCardsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRateCardsRequest.Builder>(){

            @Override
            public ListRateCardsRequest.Builder get() {
                return ListRateCardsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRateCardsResponse, String>(){

            @Override
            public String apply(ListRateCardsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRateCardsRequest.Builder>, ListRateCardsRequest>(){

            @Override
            public ListRateCardsRequest apply(RequestBuilderAndToken<ListRateCardsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRateCardsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRateCardsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRateCardsRequest, ListRateCardsResponse>(){

            @Override
            public ListRateCardsResponse apply(ListRateCardsRequest request) {
                return RatecardPaginators.this.client.listRateCards(request);
            }
        });
    }

    public Iterable<RateCardSummary> listRateCardsRecordIterator(final ListRateCardsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRateCardsRequest.Builder>(){

            @Override
            public ListRateCardsRequest.Builder get() {
                return ListRateCardsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRateCardsResponse, String>(){

            @Override
            public String apply(ListRateCardsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRateCardsRequest.Builder>, ListRateCardsRequest>(){

            @Override
            public ListRateCardsRequest apply(RequestBuilderAndToken<ListRateCardsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRateCardsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRateCardsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRateCardsRequest, ListRateCardsResponse>(){

            @Override
            public ListRateCardsResponse apply(ListRateCardsRequest request) {
                return RatecardPaginators.this.client.listRateCards(request);
            }
        }, (Function)new Function<ListRateCardsResponse, List<RateCardSummary>>(){

            @Override
            public List<RateCardSummary> apply(ListRateCardsResponse response) {
                return response.getItems();
            }
        });
    }
}

