/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osubusage.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListComputedUsageAggregatedsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String subscriptionId;
    private Date timeFrom;
    private Date timeTo;
    private String parentProduct;
    private Grouping grouping;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private String xOneOriginRegion;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public Date getTimeFrom() {
        return this.timeFrom;
    }

    public Date getTimeTo() {
        return this.timeTo;
    }

    public String getParentProduct() {
        return this.parentProduct;
    }

    public Grouping getGrouping() {
        return this.grouping;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getXOneOriginRegion() {
        return this.xOneOriginRegion;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).subscriptionId(this.subscriptionId).timeFrom(this.timeFrom).timeTo(this.timeTo).parentProduct(this.parentProduct).grouping(this.grouping).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).xOneOriginRegion(this.xOneOriginRegion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(",timeFrom=").append(String.valueOf(this.timeFrom));
        sb.append(",timeTo=").append(String.valueOf(this.timeTo));
        sb.append(",parentProduct=").append(String.valueOf(this.parentProduct));
        sb.append(",grouping=").append(String.valueOf((Object)this.grouping));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",xOneOriginRegion=").append(String.valueOf(this.xOneOriginRegion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListComputedUsageAggregatedsRequest)) {
            return false;
        }
        ListComputedUsageAggregatedsRequest other = (ListComputedUsageAggregatedsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.timeFrom, other.timeFrom) && Objects.equals(this.timeTo, other.timeTo) && Objects.equals(this.parentProduct, other.parentProduct) && Objects.equals((Object)this.grouping, (Object)other.grouping) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.xOneOriginRegion, other.xOneOriginRegion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.timeFrom == null ? 43 : this.timeFrom.hashCode());
        result = result * 59 + (this.timeTo == null ? 43 : this.timeTo.hashCode());
        result = result * 59 + (this.parentProduct == null ? 43 : this.parentProduct.hashCode());
        result = result * 59 + (this.grouping == null ? 43 : this.grouping.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.xOneOriginRegion == null ? 43 : this.xOneOriginRegion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListComputedUsageAggregatedsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String subscriptionId = null;
        private Date timeFrom = null;
        private Date timeTo = null;
        private String parentProduct = null;
        private Grouping grouping = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private String xOneOriginRegion = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder timeFrom(Date timeFrom) {
            this.timeFrom = timeFrom;
            return this;
        }

        public Builder timeTo(Date timeTo) {
            this.timeTo = timeTo;
            return this;
        }

        public Builder parentProduct(String parentProduct) {
            this.parentProduct = parentProduct;
            return this;
        }

        public Builder grouping(Grouping grouping) {
            this.grouping = grouping;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder xOneOriginRegion(String xOneOriginRegion) {
            this.xOneOriginRegion = xOneOriginRegion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListComputedUsageAggregatedsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.subscriptionId(o.getSubscriptionId());
            this.timeFrom(o.getTimeFrom());
            this.timeTo(o.getTimeTo());
            this.parentProduct(o.getParentProduct());
            this.grouping(o.getGrouping());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.xOneOriginRegion(o.getXOneOriginRegion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListComputedUsageAggregatedsRequest build() {
            ListComputedUsageAggregatedsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListComputedUsageAggregatedsRequest buildWithoutInvocationCallback() {
            ListComputedUsageAggregatedsRequest request = new ListComputedUsageAggregatedsRequest();
            request.compartmentId = this.compartmentId;
            request.subscriptionId = this.subscriptionId;
            request.timeFrom = this.timeFrom;
            request.timeTo = this.timeTo;
            request.parentProduct = this.parentProduct;
            request.grouping = this.grouping;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.xOneOriginRegion = this.xOneOriginRegion;
            return request;
        }
    }

    public static enum Grouping implements BmcEnum
    {
        Hourly("HOURLY"),
        Daily("DAILY"),
        Monthly("MONTHLY"),
        None("NONE");

        private final String value;
        private static Map<String, Grouping> map;

        private Grouping(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Grouping create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Grouping: " + key);
        }

        static {
            map = new HashMap<String, Grouping>();
            for (Grouping v : Grouping.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

