/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.psql.PostgresqlAsync;
import com.oracle.bmc.psql.model.Backup;
import com.oracle.bmc.psql.model.BackupCollection;
import com.oracle.bmc.psql.model.Configuration;
import com.oracle.bmc.psql.model.ConfigurationCollection;
import com.oracle.bmc.psql.model.ConnectionDetails;
import com.oracle.bmc.psql.model.DbSystem;
import com.oracle.bmc.psql.model.DbSystemCollection;
import com.oracle.bmc.psql.model.DefaultConfiguration;
import com.oracle.bmc.psql.model.DefaultConfigurationCollection;
import com.oracle.bmc.psql.model.PrimaryDbInstanceDetails;
import com.oracle.bmc.psql.model.ShapeCollection;
import com.oracle.bmc.psql.model.WorkRequest;
import com.oracle.bmc.psql.model.WorkRequestErrorCollection;
import com.oracle.bmc.psql.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.psql.model.WorkRequestSummaryCollection;
import com.oracle.bmc.psql.requests.ChangeBackupCompartmentRequest;
import com.oracle.bmc.psql.requests.ChangeConfigurationCompartmentRequest;
import com.oracle.bmc.psql.requests.ChangeDbSystemCompartmentRequest;
import com.oracle.bmc.psql.requests.CreateBackupRequest;
import com.oracle.bmc.psql.requests.CreateConfigurationRequest;
import com.oracle.bmc.psql.requests.CreateDbSystemRequest;
import com.oracle.bmc.psql.requests.DeleteBackupRequest;
import com.oracle.bmc.psql.requests.DeleteConfigurationRequest;
import com.oracle.bmc.psql.requests.DeleteDbSystemRequest;
import com.oracle.bmc.psql.requests.FailoverDbSystemRequest;
import com.oracle.bmc.psql.requests.GetBackupRequest;
import com.oracle.bmc.psql.requests.GetConfigurationRequest;
import com.oracle.bmc.psql.requests.GetConnectionDetailsRequest;
import com.oracle.bmc.psql.requests.GetDbSystemRequest;
import com.oracle.bmc.psql.requests.GetDefaultConfigurationRequest;
import com.oracle.bmc.psql.requests.GetPrimaryDbInstanceRequest;
import com.oracle.bmc.psql.requests.GetWorkRequestRequest;
import com.oracle.bmc.psql.requests.ListBackupsRequest;
import com.oracle.bmc.psql.requests.ListConfigurationsRequest;
import com.oracle.bmc.psql.requests.ListDbSystemsRequest;
import com.oracle.bmc.psql.requests.ListDefaultConfigurationsRequest;
import com.oracle.bmc.psql.requests.ListShapesRequest;
import com.oracle.bmc.psql.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.psql.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.psql.requests.ListWorkRequestsRequest;
import com.oracle.bmc.psql.requests.PatchDbSystemRequest;
import com.oracle.bmc.psql.requests.ResetMasterUserPasswordRequest;
import com.oracle.bmc.psql.requests.RestartDbInstanceInDbSystemRequest;
import com.oracle.bmc.psql.requests.RestoreDbSystemRequest;
import com.oracle.bmc.psql.requests.UpdateBackupRequest;
import com.oracle.bmc.psql.requests.UpdateConfigurationRequest;
import com.oracle.bmc.psql.requests.UpdateDbSystemDbInstanceRequest;
import com.oracle.bmc.psql.requests.UpdateDbSystemRequest;
import com.oracle.bmc.psql.responses.ChangeBackupCompartmentResponse;
import com.oracle.bmc.psql.responses.ChangeConfigurationCompartmentResponse;
import com.oracle.bmc.psql.responses.ChangeDbSystemCompartmentResponse;
import com.oracle.bmc.psql.responses.CreateBackupResponse;
import com.oracle.bmc.psql.responses.CreateConfigurationResponse;
import com.oracle.bmc.psql.responses.CreateDbSystemResponse;
import com.oracle.bmc.psql.responses.DeleteBackupResponse;
import com.oracle.bmc.psql.responses.DeleteConfigurationResponse;
import com.oracle.bmc.psql.responses.DeleteDbSystemResponse;
import com.oracle.bmc.psql.responses.FailoverDbSystemResponse;
import com.oracle.bmc.psql.responses.GetBackupResponse;
import com.oracle.bmc.psql.responses.GetConfigurationResponse;
import com.oracle.bmc.psql.responses.GetConnectionDetailsResponse;
import com.oracle.bmc.psql.responses.GetDbSystemResponse;
import com.oracle.bmc.psql.responses.GetDefaultConfigurationResponse;
import com.oracle.bmc.psql.responses.GetPrimaryDbInstanceResponse;
import com.oracle.bmc.psql.responses.GetWorkRequestResponse;
import com.oracle.bmc.psql.responses.ListBackupsResponse;
import com.oracle.bmc.psql.responses.ListConfigurationsResponse;
import com.oracle.bmc.psql.responses.ListDbSystemsResponse;
import com.oracle.bmc.psql.responses.ListDefaultConfigurationsResponse;
import com.oracle.bmc.psql.responses.ListShapesResponse;
import com.oracle.bmc.psql.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.psql.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.psql.responses.ListWorkRequestsResponse;
import com.oracle.bmc.psql.responses.PatchDbSystemResponse;
import com.oracle.bmc.psql.responses.ResetMasterUserPasswordResponse;
import com.oracle.bmc.psql.responses.RestartDbInstanceInDbSystemResponse;
import com.oracle.bmc.psql.responses.RestoreDbSystemResponse;
import com.oracle.bmc.psql.responses.UpdateBackupResponse;
import com.oracle.bmc.psql.responses.UpdateConfigurationResponse;
import com.oracle.bmc.psql.responses.UpdateDbSystemDbInstanceResponse;
import com.oracle.bmc.psql.responses.UpdateDbSystemResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlAsyncClient
extends BaseAsyncClient
implements PostgresqlAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("POSTGRESQL").serviceEndpointPrefix("").serviceEndpointTemplate("https://postgresql.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(PostgresqlAsyncClient.class);

    PostgresqlAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeBackupCompartmentResponse> changeBackupCompartment(ChangeBackupCompartmentRequest request, AsyncHandler<ChangeBackupCompartmentRequest, ChangeBackupCompartmentResponse> handler) {
        Validate.notBlank((String)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeBackupCompartmentDetails(), "changeBackupCompartmentDetails is required");
        return this.clientCall(request, ChangeBackupCompartmentResponse::builder).logger(LOG, "changeBackupCompartment").serviceDetails("Postgresql", "ChangeBackupCompartment", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/Backup/ChangeBackupCompartment").method(Method.POST).requestBuilder(ChangeBackupCompartmentRequest::builder).basePath("/20220915").appendPathParam("backups").appendPathParam(request.getBackupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeBackupCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeBackupCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeConfigurationCompartmentResponse> changeConfigurationCompartment(ChangeConfigurationCompartmentRequest request, AsyncHandler<ChangeConfigurationCompartmentRequest, ChangeConfigurationCompartmentResponse> handler) {
        Validate.notBlank((String)request.getConfigurationId(), (String)"configurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeConfigurationCompartmentDetails(), "changeConfigurationCompartmentDetails is required");
        return this.clientCall(request, ChangeConfigurationCompartmentResponse::builder).logger(LOG, "changeConfigurationCompartment").serviceDetails("Postgresql", "ChangeConfigurationCompartment", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/Configuration/ChangeConfigurationCompartment").method(Method.POST).requestBuilder(ChangeConfigurationCompartmentRequest::builder).basePath("/20220915").appendPathParam("configurations").appendPathParam(request.getConfigurationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeConfigurationCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDbSystemCompartmentResponse> changeDbSystemCompartment(ChangeDbSystemCompartmentRequest request, AsyncHandler<ChangeDbSystemCompartmentRequest, ChangeDbSystemCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDbSystemCompartmentDetails(), "changeDbSystemCompartmentDetails is required");
        return this.clientCall(request, ChangeDbSystemCompartmentResponse::builder).logger(LOG, "changeDbSystemCompartment").serviceDetails("Postgresql", "ChangeDbSystemCompartment", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystem/ChangeDbSystemCompartment").method(Method.POST).requestBuilder(ChangeDbSystemCompartmentRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeDbSystemCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeDbSystemCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateBackupResponse> createBackup(CreateBackupRequest request, AsyncHandler<CreateBackupRequest, CreateBackupResponse> handler) {
        Objects.requireNonNull(request.getCreateBackupDetails(), "createBackupDetails is required");
        return this.clientCall(request, CreateBackupResponse::builder).logger(LOG, "createBackup").serviceDetails("Postgresql", "CreateBackup", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/Backup/CreateBackup").method(Method.POST).requestBuilder(CreateBackupRequest::builder).basePath("/20220915").appendPathParam("backups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBackupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateConfigurationResponse> createConfiguration(CreateConfigurationRequest request, AsyncHandler<CreateConfigurationRequest, CreateConfigurationResponse> handler) {
        Objects.requireNonNull(request.getCreateConfigurationDetails(), "createConfigurationDetails is required");
        return this.clientCall(request, CreateConfigurationResponse::builder).logger(LOG, "createConfiguration").serviceDetails("Postgresql", "CreateConfiguration", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/Configuration/CreateConfiguration").method(Method.POST).requestBuilder(CreateConfigurationRequest::builder).basePath("/20220915").appendPathParam("configurations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Configuration.class, CreateConfigurationResponse.Builder::configuration).handleResponseHeaderString("opc-request-id", CreateConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateConfigurationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateDbSystemResponse> createDbSystem(CreateDbSystemRequest request, AsyncHandler<CreateDbSystemRequest, CreateDbSystemResponse> handler) {
        Objects.requireNonNull(request.getCreateDbSystemDetails(), "createDbSystemDetails is required");
        return this.clientCall(request, CreateDbSystemResponse::builder).logger(LOG, "createDbSystem").serviceDetails("Postgresql", "CreateDbSystem", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystem/CreateDbSystem").method(Method.POST).requestBuilder(CreateDbSystemRequest::builder).basePath("/20220915").appendPathParam("dbSystems").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DbSystem.class, CreateDbSystemResponse.Builder::dbSystem).handleResponseHeaderString("etag", CreateDbSystemResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDbSystemResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDbSystemResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteBackupResponse> deleteBackup(DeleteBackupRequest request, AsyncHandler<DeleteBackupRequest, DeleteBackupResponse> handler) {
        Validate.notBlank((String)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteBackupResponse::builder).logger(LOG, "deleteBackup").serviceDetails("Postgresql", "DeleteBackup", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/Backup/DeleteBackup").method(Method.DELETE).requestBuilder(DeleteBackupRequest::builder).basePath("/20220915").appendPathParam("backups").appendPathParam(request.getBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBackupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteConfigurationResponse> deleteConfiguration(DeleteConfigurationRequest request, AsyncHandler<DeleteConfigurationRequest, DeleteConfigurationResponse> handler) {
        Validate.notBlank((String)request.getConfigurationId(), (String)"configurationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteConfigurationResponse::builder).logger(LOG, "deleteConfiguration").serviceDetails("Postgresql", "DeleteConfiguration", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/Configuration/DeleteConfiguration").method(Method.DELETE).requestBuilder(DeleteConfigurationRequest::builder).basePath("/20220915").appendPathParam("configurations").appendPathParam(request.getConfigurationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDbSystemResponse> deleteDbSystem(DeleteDbSystemRequest request, AsyncHandler<DeleteDbSystemRequest, DeleteDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDbSystemResponse::builder).logger(LOG, "deleteDbSystem").serviceDetails("Postgresql", "DeleteDbSystem", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystem/DeleteDbSystem").method(Method.DELETE).requestBuilder(DeleteDbSystemRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDbSystemResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDbSystemResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<FailoverDbSystemResponse> failoverDbSystem(FailoverDbSystemRequest request, AsyncHandler<FailoverDbSystemRequest, FailoverDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getFailoverDbSystemDetails(), "failoverDbSystemDetails is required");
        return this.clientCall(request, FailoverDbSystemResponse::builder).logger(LOG, "failoverDbSystem").serviceDetails("Postgresql", "FailoverDbSystem", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystem/FailoverDbSystem").method(Method.POST).requestBuilder(FailoverDbSystemRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("failover").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", FailoverDbSystemResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", FailoverDbSystemResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetBackupResponse> getBackup(GetBackupRequest request, AsyncHandler<GetBackupRequest, GetBackupResponse> handler) {
        Validate.notBlank((String)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBackupResponse::builder).logger(LOG, "getBackup").serviceDetails("Postgresql", "GetBackup", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/Backup/GetBackup").method(Method.GET).requestBuilder(GetBackupRequest::builder).basePath("/20220915").appendPathParam("backups").appendPathParam(request.getBackupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Backup.class, GetBackupResponse.Builder::backup).handleResponseHeaderString("etag", GetBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBackupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetConfigurationResponse> getConfiguration(GetConfigurationRequest request, AsyncHandler<GetConfigurationRequest, GetConfigurationResponse> handler) {
        Validate.notBlank((String)request.getConfigurationId(), (String)"configurationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConfigurationResponse::builder).logger(LOG, "getConfiguration").serviceDetails("Postgresql", "GetConfiguration", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/Configuration/GetConfiguration").method(Method.GET).requestBuilder(GetConfigurationRequest::builder).basePath("/20220915").appendPathParam("configurations").appendPathParam(request.getConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Configuration.class, GetConfigurationResponse.Builder::configuration).handleResponseHeaderString("etag", GetConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetConnectionDetailsResponse> getConnectionDetails(GetConnectionDetailsRequest request, AsyncHandler<GetConnectionDetailsRequest, GetConnectionDetailsResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConnectionDetailsResponse::builder).logger(LOG, "getConnectionDetails").serviceDetails("Postgresql", "GetConnectionDetails", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/ConnectionDetails/GetConnectionDetails").method(Method.GET).requestBuilder(GetConnectionDetailsRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("connectionDetails").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectionDetails.class, GetConnectionDetailsResponse.Builder::connectionDetails).handleResponseHeaderString("etag", GetConnectionDetailsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConnectionDetailsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDbSystemResponse> getDbSystem(GetDbSystemRequest request, AsyncHandler<GetDbSystemRequest, GetDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDbSystemResponse::builder).logger(LOG, "getDbSystem").serviceDetails("Postgresql", "GetDbSystem", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystem/GetDbSystem").method(Method.GET).requestBuilder(GetDbSystemRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendListQueryParam("excludedFields", request.getExcludedFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DbSystem.class, GetDbSystemResponse.Builder::dbSystem).handleResponseHeaderString("etag", GetDbSystemResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDbSystemResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDefaultConfigurationResponse> getDefaultConfiguration(GetDefaultConfigurationRequest request, AsyncHandler<GetDefaultConfigurationRequest, GetDefaultConfigurationResponse> handler) {
        Validate.notBlank((String)request.getDefaultConfigurationId(), (String)"defaultConfigurationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDefaultConfigurationResponse::builder).logger(LOG, "getDefaultConfiguration").serviceDetails("Postgresql", "GetDefaultConfiguration", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DefaultConfiguration/GetDefaultConfiguration").method(Method.GET).requestBuilder(GetDefaultConfigurationRequest::builder).basePath("/20220915").appendPathParam("defaultConfigurations").appendPathParam(request.getDefaultConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DefaultConfiguration.class, GetDefaultConfigurationResponse.Builder::defaultConfiguration).handleResponseHeaderString("etag", GetDefaultConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDefaultConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPrimaryDbInstanceResponse> getPrimaryDbInstance(GetPrimaryDbInstanceRequest request, AsyncHandler<GetPrimaryDbInstanceRequest, GetPrimaryDbInstanceResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPrimaryDbInstanceResponse::builder).logger(LOG, "getPrimaryDbInstance").serviceDetails("Postgresql", "GetPrimaryDbInstance", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystem/GetPrimaryDbInstance").method(Method.GET).requestBuilder(GetPrimaryDbInstanceRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("primaryDbInstance").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PrimaryDbInstanceDetails.class, GetPrimaryDbInstanceResponse.Builder::primaryDbInstanceDetails).handleResponseHeaderString("etag", GetPrimaryDbInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPrimaryDbInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Postgresql", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220915").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListBackupsResponse> listBackups(ListBackupsRequest request, AsyncHandler<ListBackupsRequest, ListBackupsResponse> handler) {
        return this.clientCall(request, ListBackupsResponse::builder).logger(LOG, "listBackups").serviceDetails("Postgresql", "ListBackups", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/BackupCollection/ListBackups").method(Method.GET).requestBuilder(ListBackupsRequest::builder).basePath("/20220915").appendPathParam("backups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("timeStarted", (Object)request.getTimeStarted()).appendQueryParam("timeEnded", (Object)request.getTimeEnded()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("backupId", (Object)request.getBackupId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BackupCollection.class, ListBackupsResponse.Builder::backupCollection).handleResponseHeaderString("opc-request-id", ListBackupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBackupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListConfigurationsResponse> listConfigurations(ListConfigurationsRequest request, AsyncHandler<ListConfigurationsRequest, ListConfigurationsResponse> handler) {
        return this.clientCall(request, ListConfigurationsResponse::builder).logger(LOG, "listConfigurations").serviceDetails("Postgresql", "ListConfigurations", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/ConfigurationCollection/ListConfigurations").method(Method.GET).requestBuilder(ListConfigurationsRequest::builder).basePath("/20220915").appendPathParam("configurations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("dbVersion", (Object)request.getDbVersion()).appendQueryParam("shape", (Object)request.getShape()).appendQueryParam("configurationId", (Object)request.getConfigurationId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConfigurationCollection.class, ListConfigurationsResponse.Builder::configurationCollection).handleResponseHeaderString("opc-request-id", ListConfigurationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConfigurationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDbSystemsResponse> listDbSystems(ListDbSystemsRequest request, AsyncHandler<ListDbSystemsRequest, ListDbSystemsResponse> handler) {
        return this.clientCall(request, ListDbSystemsResponse::builder).logger(LOG, "listDbSystems").serviceDetails("Postgresql", "ListDbSystems", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystemCollection/ListDbSystems").method(Method.GET).requestBuilder(ListDbSystemsRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DbSystemCollection.class, ListDbSystemsResponse.Builder::dbSystemCollection).handleResponseHeaderString("opc-request-id", ListDbSystemsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDbSystemsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDefaultConfigurationsResponse> listDefaultConfigurations(ListDefaultConfigurationsRequest request, AsyncHandler<ListDefaultConfigurationsRequest, ListDefaultConfigurationsResponse> handler) {
        return this.clientCall(request, ListDefaultConfigurationsResponse::builder).logger(LOG, "listDefaultConfigurations").serviceDetails("Postgresql", "ListDefaultConfigurations", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DefaultConfigurationCollection/ListDefaultConfigurations").method(Method.GET).requestBuilder(ListDefaultConfigurationsRequest::builder).basePath("/20220915").appendPathParam("defaultConfigurations").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("dbVersion", (Object)request.getDbVersion()).appendQueryParam("shape", (Object)request.getShape()).appendQueryParam("configurationId", (Object)request.getConfigurationId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DefaultConfigurationCollection.class, ListDefaultConfigurationsResponse.Builder::defaultConfigurationCollection).handleResponseHeaderString("opc-request-id", ListDefaultConfigurationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDefaultConfigurationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListShapesResponse> listShapes(ListShapesRequest request, AsyncHandler<ListShapesRequest, ListShapesResponse> handler) {
        return this.clientCall(request, ListShapesResponse::builder).logger(LOG, "listShapes").serviceDetails("Postgresql", "ListShapes", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/ShapeSummary/ListShapes").method(Method.GET).requestBuilder(ListShapesRequest::builder).basePath("/20220915").appendPathParam("shapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ShapeCollection.class, ListShapesResponse.Builder::shapeCollection).handleResponseHeaderString("opc-request-id", ListShapesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListShapesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Postgresql", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220915").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Postgresql", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220915").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Postgresql", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220915").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<PatchDbSystemResponse> patchDbSystem(PatchDbSystemRequest request, AsyncHandler<PatchDbSystemRequest, PatchDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPatchDbSystemDetails(), "patchDbSystemDetails is required");
        return this.clientCall(request, PatchDbSystemResponse::builder).logger(LOG, "patchDbSystem").serviceDetails("Postgresql", "PatchDbSystem", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystem/PatchDbSystem").method(Method.PATCH).requestBuilder(PatchDbSystemRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", PatchDbSystemResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", PatchDbSystemResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ResetMasterUserPasswordResponse> resetMasterUserPassword(ResetMasterUserPasswordRequest request, AsyncHandler<ResetMasterUserPasswordRequest, ResetMasterUserPasswordResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getResetMasterUserPasswordDetails(), "resetMasterUserPasswordDetails is required");
        return this.clientCall(request, ResetMasterUserPasswordResponse::builder).logger(LOG, "resetMasterUserPassword").serviceDetails("Postgresql", "ResetMasterUserPassword", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystem/ResetMasterUserPassword").method(Method.POST).requestBuilder(ResetMasterUserPasswordRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("resetMasterUserPassword").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ResetMasterUserPasswordResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ResetMasterUserPasswordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RestartDbInstanceInDbSystemResponse> restartDbInstanceInDbSystem(RestartDbInstanceInDbSystemRequest request, AsyncHandler<RestartDbInstanceInDbSystemRequest, RestartDbInstanceInDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRestartDbInstanceInDbSystemDetails(), "restartDbInstanceInDbSystemDetails is required");
        return this.clientCall(request, RestartDbInstanceInDbSystemResponse::builder).logger(LOG, "restartDbInstanceInDbSystem").serviceDetails("Postgresql", "RestartDbInstanceInDbSystem", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystem/RestartDbInstanceInDbSystem").method(Method.POST).requestBuilder(RestartDbInstanceInDbSystemRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("restartDbInstance").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", RestartDbInstanceInDbSystemResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RestartDbInstanceInDbSystemResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RestoreDbSystemResponse> restoreDbSystem(RestoreDbSystemRequest request, AsyncHandler<RestoreDbSystemRequest, RestoreDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRestoreDbSystemDetails(), "restoreDbSystemDetails is required");
        return this.clientCall(request, RestoreDbSystemResponse::builder).logger(LOG, "restoreDbSystem").serviceDetails("Postgresql", "RestoreDbSystem", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystem/RestoreDbSystem").method(Method.POST).requestBuilder(RestoreDbSystemRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("restore").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", RestoreDbSystemResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RestoreDbSystemResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateBackupResponse> updateBackup(UpdateBackupRequest request, AsyncHandler<UpdateBackupRequest, UpdateBackupResponse> handler) {
        Validate.notBlank((String)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBackupDetails(), "updateBackupDetails is required");
        return this.clientCall(request, UpdateBackupResponse::builder).logger(LOG, "updateBackup").serviceDetails("Postgresql", "UpdateBackup", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/Backup/UpdateBackup").method(Method.PUT).requestBuilder(UpdateBackupRequest::builder).basePath("/20220915").appendPathParam("backups").appendPathParam(request.getBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Backup.class, UpdateBackupResponse.Builder::backup).handleResponseHeaderString("etag", UpdateBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateBackupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateConfigurationResponse> updateConfiguration(UpdateConfigurationRequest request, AsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResponse> handler) {
        Validate.notBlank((String)request.getConfigurationId(), (String)"configurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConfigurationDetails(), "updateConfigurationDetails is required");
        return this.clientCall(request, UpdateConfigurationResponse::builder).logger(LOG, "updateConfiguration").serviceDetails("Postgresql", "UpdateConfiguration", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/Configuration/UpdateConfiguration").method(Method.PUT).requestBuilder(UpdateConfigurationRequest::builder).basePath("/20220915").appendPathParam("configurations").appendPathParam(request.getConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Configuration.class, UpdateConfigurationResponse.Builder::configuration).handleResponseHeaderString("opc-request-id", UpdateConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateConfigurationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateDbSystemResponse> updateDbSystem(UpdateDbSystemRequest request, AsyncHandler<UpdateDbSystemRequest, UpdateDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDbSystemDetails(), "updateDbSystemDetails is required");
        return this.clientCall(request, UpdateDbSystemResponse::builder).logger(LOG, "updateDbSystem").serviceDetails("Postgresql", "UpdateDbSystem", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystem/UpdateDbSystem").method(Method.PUT).requestBuilder(UpdateDbSystemRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDbSystemResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDbSystemResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDbSystemDbInstanceResponse> updateDbSystemDbInstance(UpdateDbSystemDbInstanceRequest request, AsyncHandler<UpdateDbSystemDbInstanceRequest, UpdateDbSystemDbInstanceResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDbInstanceId(), (String)"dbInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDbSystemDbInstanceDetails(), "updateDbSystemDbInstanceDetails is required");
        return this.clientCall(request, UpdateDbSystemDbInstanceResponse::builder).logger(LOG, "updateDbSystemDbInstance").serviceDetails("Postgresql", "UpdateDbSystemDbInstance", "https://docs.oracle.com/iaas/api/#/en/postgresql/20220915/DbSystem/UpdateDbSystemDbInstance").method(Method.PUT).requestBuilder(UpdateDbSystemDbInstanceRequest::builder).basePath("/20220915").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("dbinstances").appendPathParam(request.getDbInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDbSystemDbInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDbSystemDbInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public PostgresqlAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)PostgresqlAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public PostgresqlAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(PostgresqlAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public PostgresqlAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)PostgresqlAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public PostgresqlAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)PostgresqlAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public PostgresqlAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)PostgresqlAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public PostgresqlAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)PostgresqlAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public PostgresqlAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)PostgresqlAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, PostgresqlAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "psql";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"psql");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public PostgresqlAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new PostgresqlAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

