/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.psql.Postgresql;
import com.oracle.bmc.psql.model.BackupSummary;
import com.oracle.bmc.psql.model.ConfigurationSummary;
import com.oracle.bmc.psql.model.DbSystemSummary;
import com.oracle.bmc.psql.model.DefaultConfigurationSummary;
import com.oracle.bmc.psql.model.ShapeSummary;
import com.oracle.bmc.psql.model.WorkRequestError;
import com.oracle.bmc.psql.model.WorkRequestLogEntry;
import com.oracle.bmc.psql.model.WorkRequestSummary;
import com.oracle.bmc.psql.requests.ListBackupsRequest;
import com.oracle.bmc.psql.requests.ListConfigurationsRequest;
import com.oracle.bmc.psql.requests.ListDbSystemsRequest;
import com.oracle.bmc.psql.requests.ListDefaultConfigurationsRequest;
import com.oracle.bmc.psql.requests.ListShapesRequest;
import com.oracle.bmc.psql.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.psql.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.psql.requests.ListWorkRequestsRequest;
import com.oracle.bmc.psql.responses.ListBackupsResponse;
import com.oracle.bmc.psql.responses.ListConfigurationsResponse;
import com.oracle.bmc.psql.responses.ListDbSystemsResponse;
import com.oracle.bmc.psql.responses.ListDefaultConfigurationsResponse;
import com.oracle.bmc.psql.responses.ListShapesResponse;
import com.oracle.bmc.psql.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.psql.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.psql.responses.ListWorkRequestsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class PostgresqlPaginators {
    private final Postgresql client;

    public PostgresqlPaginators(Postgresql client) {
        this.client = client;
    }

    public Iterable<ListBackupsResponse> listBackupsResponseIterator(final ListBackupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBackupsRequest.Builder>(){

            @Override
            public ListBackupsRequest.Builder get() {
                return ListBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBackupsResponse, String>(){

            @Override
            public String apply(ListBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBackupsRequest.Builder>, ListBackupsRequest>(){

            @Override
            public ListBackupsRequest apply(RequestBuilderAndToken<ListBackupsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBackupsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBackupsRequest, ListBackupsResponse>(){

            @Override
            public ListBackupsResponse apply(ListBackupsRequest request) {
                return PostgresqlPaginators.this.client.listBackups(request);
            }
        });
    }

    public Iterable<BackupSummary> listBackupsRecordIterator(final ListBackupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBackupsRequest.Builder>(){

            @Override
            public ListBackupsRequest.Builder get() {
                return ListBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBackupsResponse, String>(){

            @Override
            public String apply(ListBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBackupsRequest.Builder>, ListBackupsRequest>(){

            @Override
            public ListBackupsRequest apply(RequestBuilderAndToken<ListBackupsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBackupsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBackupsRequest, ListBackupsResponse>(){

            @Override
            public ListBackupsResponse apply(ListBackupsRequest request) {
                return PostgresqlPaginators.this.client.listBackups(request);
            }
        }, (Function)new Function<ListBackupsResponse, List<BackupSummary>>(){

            @Override
            public List<BackupSummary> apply(ListBackupsResponse response) {
                return response.getBackupCollection().getItems();
            }
        });
    }

    public Iterable<ListConfigurationsResponse> listConfigurationsResponseIterator(final ListConfigurationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConfigurationsRequest.Builder>(){

            @Override
            public ListConfigurationsRequest.Builder get() {
                return ListConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConfigurationsResponse, String>(){

            @Override
            public String apply(ListConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConfigurationsRequest.Builder>, ListConfigurationsRequest>(){

            @Override
            public ListConfigurationsRequest apply(RequestBuilderAndToken<ListConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConfigurationsRequest, ListConfigurationsResponse>(){

            @Override
            public ListConfigurationsResponse apply(ListConfigurationsRequest request) {
                return PostgresqlPaginators.this.client.listConfigurations(request);
            }
        });
    }

    public Iterable<ConfigurationSummary> listConfigurationsRecordIterator(final ListConfigurationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConfigurationsRequest.Builder>(){

            @Override
            public ListConfigurationsRequest.Builder get() {
                return ListConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConfigurationsResponse, String>(){

            @Override
            public String apply(ListConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConfigurationsRequest.Builder>, ListConfigurationsRequest>(){

            @Override
            public ListConfigurationsRequest apply(RequestBuilderAndToken<ListConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConfigurationsRequest, ListConfigurationsResponse>(){

            @Override
            public ListConfigurationsResponse apply(ListConfigurationsRequest request) {
                return PostgresqlPaginators.this.client.listConfigurations(request);
            }
        }, (Function)new Function<ListConfigurationsResponse, List<ConfigurationSummary>>(){

            @Override
            public List<ConfigurationSummary> apply(ListConfigurationsResponse response) {
                return response.getConfigurationCollection().getItems();
            }
        });
    }

    public Iterable<ListDbSystemsResponse> listDbSystemsResponseIterator(final ListDbSystemsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDbSystemsRequest.Builder>(){

            @Override
            public ListDbSystemsRequest.Builder get() {
                return ListDbSystemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbSystemsResponse, String>(){

            @Override
            public String apply(ListDbSystemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbSystemsRequest.Builder>, ListDbSystemsRequest>(){

            @Override
            public ListDbSystemsRequest apply(RequestBuilderAndToken<ListDbSystemsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDbSystemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbSystemsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDbSystemsRequest, ListDbSystemsResponse>(){

            @Override
            public ListDbSystemsResponse apply(ListDbSystemsRequest request) {
                return PostgresqlPaginators.this.client.listDbSystems(request);
            }
        });
    }

    public Iterable<DbSystemSummary> listDbSystemsRecordIterator(final ListDbSystemsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDbSystemsRequest.Builder>(){

            @Override
            public ListDbSystemsRequest.Builder get() {
                return ListDbSystemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbSystemsResponse, String>(){

            @Override
            public String apply(ListDbSystemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbSystemsRequest.Builder>, ListDbSystemsRequest>(){

            @Override
            public ListDbSystemsRequest apply(RequestBuilderAndToken<ListDbSystemsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDbSystemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbSystemsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDbSystemsRequest, ListDbSystemsResponse>(){

            @Override
            public ListDbSystemsResponse apply(ListDbSystemsRequest request) {
                return PostgresqlPaginators.this.client.listDbSystems(request);
            }
        }, (Function)new Function<ListDbSystemsResponse, List<DbSystemSummary>>(){

            @Override
            public List<DbSystemSummary> apply(ListDbSystemsResponse response) {
                return response.getDbSystemCollection().getItems();
            }
        });
    }

    public Iterable<ListDefaultConfigurationsResponse> listDefaultConfigurationsResponseIterator(final ListDefaultConfigurationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDefaultConfigurationsRequest.Builder>(){

            @Override
            public ListDefaultConfigurationsRequest.Builder get() {
                return ListDefaultConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDefaultConfigurationsResponse, String>(){

            @Override
            public String apply(ListDefaultConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDefaultConfigurationsRequest.Builder>, ListDefaultConfigurationsRequest>(){

            @Override
            public ListDefaultConfigurationsRequest apply(RequestBuilderAndToken<ListDefaultConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDefaultConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDefaultConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDefaultConfigurationsRequest, ListDefaultConfigurationsResponse>(){

            @Override
            public ListDefaultConfigurationsResponse apply(ListDefaultConfigurationsRequest request) {
                return PostgresqlPaginators.this.client.listDefaultConfigurations(request);
            }
        });
    }

    public Iterable<DefaultConfigurationSummary> listDefaultConfigurationsRecordIterator(final ListDefaultConfigurationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDefaultConfigurationsRequest.Builder>(){

            @Override
            public ListDefaultConfigurationsRequest.Builder get() {
                return ListDefaultConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDefaultConfigurationsResponse, String>(){

            @Override
            public String apply(ListDefaultConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDefaultConfigurationsRequest.Builder>, ListDefaultConfigurationsRequest>(){

            @Override
            public ListDefaultConfigurationsRequest apply(RequestBuilderAndToken<ListDefaultConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDefaultConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDefaultConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDefaultConfigurationsRequest, ListDefaultConfigurationsResponse>(){

            @Override
            public ListDefaultConfigurationsResponse apply(ListDefaultConfigurationsRequest request) {
                return PostgresqlPaginators.this.client.listDefaultConfigurations(request);
            }
        }, (Function)new Function<ListDefaultConfigurationsResponse, List<DefaultConfigurationSummary>>(){

            @Override
            public List<DefaultConfigurationSummary> apply(ListDefaultConfigurationsResponse response) {
                return response.getDefaultConfigurationCollection().getItems();
            }
        });
    }

    public Iterable<ListShapesResponse> listShapesResponseIterator(final ListShapesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListShapesRequest.Builder>(){

            @Override
            public ListShapesRequest.Builder get() {
                return ListShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListShapesResponse, String>(){

            @Override
            public String apply(ListShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListShapesRequest.Builder>, ListShapesRequest>(){

            @Override
            public ListShapesRequest apply(RequestBuilderAndToken<ListShapesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListShapesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListShapesRequest, ListShapesResponse>(){

            @Override
            public ListShapesResponse apply(ListShapesRequest request) {
                return PostgresqlPaginators.this.client.listShapes(request);
            }
        });
    }

    public Iterable<ShapeSummary> listShapesRecordIterator(final ListShapesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListShapesRequest.Builder>(){

            @Override
            public ListShapesRequest.Builder get() {
                return ListShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListShapesResponse, String>(){

            @Override
            public String apply(ListShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListShapesRequest.Builder>, ListShapesRequest>(){

            @Override
            public ListShapesRequest apply(RequestBuilderAndToken<ListShapesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListShapesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListShapesRequest, ListShapesResponse>(){

            @Override
            public ListShapesResponse apply(ListShapesRequest request) {
                return PostgresqlPaginators.this.client.listShapes(request);
            }
        }, (Function)new Function<ListShapesResponse, List<ShapeSummary>>(){

            @Override
            public List<ShapeSummary> apply(ListShapesResponse response) {
                return response.getShapeCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return PostgresqlPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return PostgresqlPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return PostgresqlPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return PostgresqlPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return PostgresqlPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return PostgresqlPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

