/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql;

import com.oracle.bmc.psql.Postgresql;
import com.oracle.bmc.psql.model.Backup;
import com.oracle.bmc.psql.model.Configuration;
import com.oracle.bmc.psql.model.DbSystem;
import com.oracle.bmc.psql.model.DefaultConfiguration;
import com.oracle.bmc.psql.requests.GetBackupRequest;
import com.oracle.bmc.psql.requests.GetConfigurationRequest;
import com.oracle.bmc.psql.requests.GetDbSystemRequest;
import com.oracle.bmc.psql.requests.GetDefaultConfigurationRequest;
import com.oracle.bmc.psql.requests.GetWorkRequestRequest;
import com.oracle.bmc.psql.responses.GetBackupResponse;
import com.oracle.bmc.psql.responses.GetConfigurationResponse;
import com.oracle.bmc.psql.responses.GetDbSystemResponse;
import com.oracle.bmc.psql.responses.GetDefaultConfigurationResponse;
import com.oracle.bmc.psql.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class PostgresqlWaiters {
    private final ExecutorService executorService;
    private final Postgresql client;

    public PostgresqlWaiters(ExecutorService executorService, Postgresql client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetBackupRequest, GetBackupResponse> forBackup(GetBackupRequest request, Backup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBackupRequest, GetBackupResponse> forBackup(GetBackupRequest request, Backup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBackupRequest, GetBackupResponse> forBackup(GetBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Backup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBackupRequest, GetBackupResponse> forBackup(BmcGenericWaiter waiter, GetBackupRequest request, Backup.LifecycleState ... targetStates) {
        final HashSet<Backup.LifecycleState> targetStatesSet = new HashSet<Backup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBackupRequest, GetBackupResponse>(){

            @Override
            public GetBackupResponse apply(GetBackupRequest request) {
                return PostgresqlWaiters.this.client.getBackup(request);
            }
        }, (Predicate)new Predicate<GetBackupResponse>(){

            @Override
            public boolean test(GetBackupResponse response) {
                return targetStatesSet.contains((Object)response.getBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Backup.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetConfigurationRequest, GetConfigurationResponse> forConfiguration(GetConfigurationRequest request, Configuration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetConfigurationRequest, GetConfigurationResponse> forConfiguration(GetConfigurationRequest request, Configuration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetConfigurationRequest, GetConfigurationResponse> forConfiguration(GetConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Configuration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetConfigurationRequest, GetConfigurationResponse> forConfiguration(BmcGenericWaiter waiter, GetConfigurationRequest request, Configuration.LifecycleState ... targetStates) {
        final HashSet<Configuration.LifecycleState> targetStatesSet = new HashSet<Configuration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetConfigurationRequest, GetConfigurationResponse>(){

            @Override
            public GetConfigurationResponse apply(GetConfigurationRequest request) {
                return PostgresqlWaiters.this.client.getConfiguration(request);
            }
        }, (Predicate)new Predicate<GetConfigurationResponse>(){

            @Override
            public boolean test(GetConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Configuration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(GetDbSystemRequest request, DbSystem.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDbSystem(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(GetDbSystemRequest request, DbSystem.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDbSystem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(GetDbSystemRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DbSystem.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDbSystem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(BmcGenericWaiter waiter, GetDbSystemRequest request, DbSystem.LifecycleState ... targetStates) {
        final HashSet<DbSystem.LifecycleState> targetStatesSet = new HashSet<DbSystem.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDbSystemRequest, GetDbSystemResponse>(){

            @Override
            public GetDbSystemResponse apply(GetDbSystemRequest request) {
                return PostgresqlWaiters.this.client.getDbSystem(request);
            }
        }, (Predicate)new Predicate<GetDbSystemResponse>(){

            @Override
            public boolean test(GetDbSystemResponse response) {
                return targetStatesSet.contains((Object)response.getDbSystem().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DbSystem.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDefaultConfigurationRequest, GetDefaultConfigurationResponse> forDefaultConfiguration(GetDefaultConfigurationRequest request, DefaultConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDefaultConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDefaultConfigurationRequest, GetDefaultConfigurationResponse> forDefaultConfiguration(GetDefaultConfigurationRequest request, DefaultConfiguration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDefaultConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDefaultConfigurationRequest, GetDefaultConfigurationResponse> forDefaultConfiguration(GetDefaultConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DefaultConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDefaultConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDefaultConfigurationRequest, GetDefaultConfigurationResponse> forDefaultConfiguration(BmcGenericWaiter waiter, GetDefaultConfigurationRequest request, DefaultConfiguration.LifecycleState ... targetStates) {
        final HashSet<DefaultConfiguration.LifecycleState> targetStatesSet = new HashSet<DefaultConfiguration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDefaultConfigurationRequest, GetDefaultConfigurationResponse>(){

            @Override
            public GetDefaultConfigurationResponse apply(GetDefaultConfigurationRequest request) {
                return PostgresqlWaiters.this.client.getDefaultConfiguration(request);
            }
        }, (Predicate)new Predicate<GetDefaultConfigurationResponse>(){

            @Override
            public boolean test(GetDefaultConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getDefaultConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DefaultConfiguration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return PostgresqlWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

