/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.psql.model.DbSystemDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Backup
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="sourceType")
    private final SourceType sourceType;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="retentionPeriod")
    private final Integer retentionPeriod;
    @JsonProperty(value="backupSize")
    private final Integer backupSize;
    @JsonProperty(value="dbSystemId")
    private final String dbSystemId;
    @JsonProperty(value="dbSystemDetails")
    private final DbSystemDetails dbSystemDetails;
    @JsonProperty(value="lastAcceptedRequestToken")
    private final String lastAcceptedRequestToken;
    @JsonProperty(value="lastCompletedRequestToken")
    private final String lastCompletedRequestToken;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "description", "compartmentId", "sourceType", "timeCreated", "timeUpdated", "lifecycleState", "lifecycleDetails", "retentionPeriod", "backupSize", "dbSystemId", "dbSystemDetails", "lastAcceptedRequestToken", "lastCompletedRequestToken", "freeformTags", "definedTags", "systemTags"})
    public Backup(String id, String displayName, String description, String compartmentId, SourceType sourceType, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String lifecycleDetails, Integer retentionPeriod, Integer backupSize, String dbSystemId, DbSystemDetails dbSystemDetails, String lastAcceptedRequestToken, String lastCompletedRequestToken, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.compartmentId = compartmentId;
        this.sourceType = sourceType;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.retentionPeriod = retentionPeriod;
        this.backupSize = backupSize;
        this.dbSystemId = dbSystemId;
        this.dbSystemDetails = dbSystemDetails;
        this.lastAcceptedRequestToken = lastAcceptedRequestToken;
        this.lastCompletedRequestToken = lastCompletedRequestToken;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Integer getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public Integer getBackupSize() {
        return this.backupSize;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public DbSystemDetails getDbSystemDetails() {
        return this.dbSystemDetails;
    }

    public String getLastAcceptedRequestToken() {
        return this.lastAcceptedRequestToken;
    }

    public String getLastCompletedRequestToken() {
        return this.lastCompletedRequestToken;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Backup(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", sourceType=").append(String.valueOf((Object)this.sourceType));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", retentionPeriod=").append(String.valueOf(this.retentionPeriod));
        sb.append(", backupSize=").append(String.valueOf(this.backupSize));
        sb.append(", dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(", dbSystemDetails=").append(String.valueOf((Object)this.dbSystemDetails));
        sb.append(", lastAcceptedRequestToken=").append(String.valueOf(this.lastAcceptedRequestToken));
        sb.append(", lastCompletedRequestToken=").append(String.valueOf(this.lastCompletedRequestToken));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Backup)) {
            return false;
        }
        Backup other = (Backup)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.sourceType, (Object)other.sourceType) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.retentionPeriod, other.retentionPeriod) && Objects.equals(this.backupSize, other.backupSize) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals((Object)this.dbSystemDetails, (Object)other.dbSystemDetails) && Objects.equals(this.lastAcceptedRequestToken, other.lastAcceptedRequestToken) && Objects.equals(this.lastCompletedRequestToken, other.lastCompletedRequestToken) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.sourceType == null ? 43 : this.sourceType.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.retentionPeriod == null ? 43 : this.retentionPeriod.hashCode());
        result = result * 59 + (this.backupSize == null ? 43 : this.backupSize.hashCode());
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.dbSystemDetails == null ? 43 : this.dbSystemDetails.hashCode());
        result = result * 59 + (this.lastAcceptedRequestToken == null ? 43 : this.lastAcceptedRequestToken.hashCode());
        result = result * 59 + (this.lastCompletedRequestToken == null ? 43 : this.lastCompletedRequestToken.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SourceType implements BmcEnum
    {
        Scheduled("SCHEDULED"),
        Manual("MANUAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SourceType> map;

        private SourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SourceType.class);
            map = new HashMap<String, SourceType>();
            for (SourceType v : SourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="sourceType")
        private SourceType sourceType;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="retentionPeriod")
        private Integer retentionPeriod;
        @JsonProperty(value="backupSize")
        private Integer backupSize;
        @JsonProperty(value="dbSystemId")
        private String dbSystemId;
        @JsonProperty(value="dbSystemDetails")
        private DbSystemDetails dbSystemDetails;
        @JsonProperty(value="lastAcceptedRequestToken")
        private String lastAcceptedRequestToken;
        @JsonProperty(value="lastCompletedRequestToken")
        private String lastCompletedRequestToken;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder sourceType(SourceType sourceType) {
            this.sourceType = sourceType;
            this.__explicitlySet__.add("sourceType");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            this.__explicitlySet__.add("retentionPeriod");
            return this;
        }

        public Builder backupSize(Integer backupSize) {
            this.backupSize = backupSize;
            this.__explicitlySet__.add("backupSize");
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            this.__explicitlySet__.add("dbSystemId");
            return this;
        }

        public Builder dbSystemDetails(DbSystemDetails dbSystemDetails) {
            this.dbSystemDetails = dbSystemDetails;
            this.__explicitlySet__.add("dbSystemDetails");
            return this;
        }

        public Builder lastAcceptedRequestToken(String lastAcceptedRequestToken) {
            this.lastAcceptedRequestToken = lastAcceptedRequestToken;
            this.__explicitlySet__.add("lastAcceptedRequestToken");
            return this;
        }

        public Builder lastCompletedRequestToken(String lastCompletedRequestToken) {
            this.lastCompletedRequestToken = lastCompletedRequestToken;
            this.__explicitlySet__.add("lastCompletedRequestToken");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Backup build() {
            Backup model = new Backup(this.id, this.displayName, this.description, this.compartmentId, this.sourceType, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.retentionPeriod, this.backupSize, this.dbSystemId, this.dbSystemDetails, this.lastAcceptedRequestToken, this.lastCompletedRequestToken, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Backup model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("sourceType")) {
                this.sourceType(model.getSourceType());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("retentionPeriod")) {
                this.retentionPeriod(model.getRetentionPeriod());
            }
            if (model.wasPropertyExplicitlySet("backupSize")) {
                this.backupSize(model.getBackupSize());
            }
            if (model.wasPropertyExplicitlySet("dbSystemId")) {
                this.dbSystemId(model.getDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("dbSystemDetails")) {
                this.dbSystemDetails(model.getDbSystemDetails());
            }
            if (model.wasPropertyExplicitlySet("lastAcceptedRequestToken")) {
                this.lastAcceptedRequestToken(model.getLastAcceptedRequestToken());
            }
            if (model.wasPropertyExplicitlySet("lastCompletedRequestToken")) {
                this.lastCompletedRequestToken(model.getLastCompletedRequestToken());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

