/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConfigParams
extends ExplicitlySetBmcModel {
    @JsonProperty(value="configKey")
    private final String configKey;
    @JsonProperty(value="defaultConfigValue")
    private final String defaultConfigValue;
    @JsonProperty(value="overridenConfigValue")
    private final String overridenConfigValue;
    @JsonProperty(value="allowedValues")
    private final String allowedValues;
    @JsonProperty(value="isRestartRequired")
    private final Boolean isRestartRequired;
    @JsonProperty(value="dataType")
    private final String dataType;
    @JsonProperty(value="isOverridable")
    private final Boolean isOverridable;
    @JsonProperty(value="description")
    private final String description;

    @Deprecated
    @ConstructorProperties(value={"configKey", "defaultConfigValue", "overridenConfigValue", "allowedValues", "isRestartRequired", "dataType", "isOverridable", "description"})
    public ConfigParams(String configKey, String defaultConfigValue, String overridenConfigValue, String allowedValues, Boolean isRestartRequired, String dataType, Boolean isOverridable, String description) {
        this.configKey = configKey;
        this.defaultConfigValue = defaultConfigValue;
        this.overridenConfigValue = overridenConfigValue;
        this.allowedValues = allowedValues;
        this.isRestartRequired = isRestartRequired;
        this.dataType = dataType;
        this.isOverridable = isOverridable;
        this.description = description;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public String getDefaultConfigValue() {
        return this.defaultConfigValue;
    }

    public String getOverridenConfigValue() {
        return this.overridenConfigValue;
    }

    public String getAllowedValues() {
        return this.allowedValues;
    }

    public Boolean getIsRestartRequired() {
        return this.isRestartRequired;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Boolean getIsOverridable() {
        return this.isOverridable;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigParams(");
        sb.append("super=").append(super.toString());
        sb.append("configKey=").append(String.valueOf(this.configKey));
        sb.append(", defaultConfigValue=").append(String.valueOf(this.defaultConfigValue));
        sb.append(", overridenConfigValue=").append(String.valueOf(this.overridenConfigValue));
        sb.append(", allowedValues=").append(String.valueOf(this.allowedValues));
        sb.append(", isRestartRequired=").append(String.valueOf(this.isRestartRequired));
        sb.append(", dataType=").append(String.valueOf(this.dataType));
        sb.append(", isOverridable=").append(String.valueOf(this.isOverridable));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigParams)) {
            return false;
        }
        ConfigParams other = (ConfigParams)((Object)o);
        return Objects.equals(this.configKey, other.configKey) && Objects.equals(this.defaultConfigValue, other.defaultConfigValue) && Objects.equals(this.overridenConfigValue, other.overridenConfigValue) && Objects.equals(this.allowedValues, other.allowedValues) && Objects.equals(this.isRestartRequired, other.isRestartRequired) && Objects.equals(this.dataType, other.dataType) && Objects.equals(this.isOverridable, other.isOverridable) && Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.configKey == null ? 43 : this.configKey.hashCode());
        result = result * 59 + (this.defaultConfigValue == null ? 43 : this.defaultConfigValue.hashCode());
        result = result * 59 + (this.overridenConfigValue == null ? 43 : this.overridenConfigValue.hashCode());
        result = result * 59 + (this.allowedValues == null ? 43 : this.allowedValues.hashCode());
        result = result * 59 + (this.isRestartRequired == null ? 43 : this.isRestartRequired.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.isOverridable == null ? 43 : this.isOverridable.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="configKey")
        private String configKey;
        @JsonProperty(value="defaultConfigValue")
        private String defaultConfigValue;
        @JsonProperty(value="overridenConfigValue")
        private String overridenConfigValue;
        @JsonProperty(value="allowedValues")
        private String allowedValues;
        @JsonProperty(value="isRestartRequired")
        private Boolean isRestartRequired;
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="isOverridable")
        private Boolean isOverridable;
        @JsonProperty(value="description")
        private String description;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder configKey(String configKey) {
            this.configKey = configKey;
            this.__explicitlySet__.add("configKey");
            return this;
        }

        public Builder defaultConfigValue(String defaultConfigValue) {
            this.defaultConfigValue = defaultConfigValue;
            this.__explicitlySet__.add("defaultConfigValue");
            return this;
        }

        public Builder overridenConfigValue(String overridenConfigValue) {
            this.overridenConfigValue = overridenConfigValue;
            this.__explicitlySet__.add("overridenConfigValue");
            return this;
        }

        public Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            this.__explicitlySet__.add("allowedValues");
            return this;
        }

        public Builder isRestartRequired(Boolean isRestartRequired) {
            this.isRestartRequired = isRestartRequired;
            this.__explicitlySet__.add("isRestartRequired");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder isOverridable(Boolean isOverridable) {
            this.isOverridable = isOverridable;
            this.__explicitlySet__.add("isOverridable");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public ConfigParams build() {
            ConfigParams model = new ConfigParams(this.configKey, this.defaultConfigValue, this.overridenConfigValue, this.allowedValues, this.isRestartRequired, this.dataType, this.isOverridable, this.description);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConfigParams model) {
            if (model.wasPropertyExplicitlySet("configKey")) {
                this.configKey(model.getConfigKey());
            }
            if (model.wasPropertyExplicitlySet("defaultConfigValue")) {
                this.defaultConfigValue(model.getDefaultConfigValue());
            }
            if (model.wasPropertyExplicitlySet("overridenConfigValue")) {
                this.overridenConfigValue(model.getOverridenConfigValue());
            }
            if (model.wasPropertyExplicitlySet("allowedValues")) {
                this.allowedValues(model.getAllowedValues());
            }
            if (model.wasPropertyExplicitlySet("isRestartRequired")) {
                this.isRestartRequired(model.getIsRestartRequired());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("isOverridable")) {
                this.isOverridable(model.getIsOverridable());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            return this;
        }
    }
}

