/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.psql.model.DbInstanceEndpoint;
import com.oracle.bmc.psql.model.Endpoint;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConnectionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="caCertificate")
    private final String caCertificate;
    @JsonProperty(value="primaryDbEndpoint")
    private final Endpoint primaryDbEndpoint;
    @JsonProperty(value="instanceEndpoints")
    private final List<DbInstanceEndpoint> instanceEndpoints;

    @Deprecated
    @ConstructorProperties(value={"caCertificate", "primaryDbEndpoint", "instanceEndpoints"})
    public ConnectionDetails(String caCertificate, Endpoint primaryDbEndpoint, List<DbInstanceEndpoint> instanceEndpoints) {
        this.caCertificate = caCertificate;
        this.primaryDbEndpoint = primaryDbEndpoint;
        this.instanceEndpoints = instanceEndpoints;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCaCertificate() {
        return this.caCertificate;
    }

    public Endpoint getPrimaryDbEndpoint() {
        return this.primaryDbEndpoint;
    }

    public List<DbInstanceEndpoint> getInstanceEndpoints() {
        return this.instanceEndpoints;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("caCertificate=").append(String.valueOf(this.caCertificate));
        sb.append(", primaryDbEndpoint=").append(String.valueOf((Object)this.primaryDbEndpoint));
        sb.append(", instanceEndpoints=").append(String.valueOf(this.instanceEndpoints));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionDetails)) {
            return false;
        }
        ConnectionDetails other = (ConnectionDetails)((Object)o);
        return Objects.equals(this.caCertificate, other.caCertificate) && Objects.equals((Object)this.primaryDbEndpoint, (Object)other.primaryDbEndpoint) && Objects.equals(this.instanceEndpoints, other.instanceEndpoints) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.caCertificate == null ? 43 : this.caCertificate.hashCode());
        result = result * 59 + (this.primaryDbEndpoint == null ? 43 : this.primaryDbEndpoint.hashCode());
        result = result * 59 + (this.instanceEndpoints == null ? 43 : this.instanceEndpoints.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="caCertificate")
        private String caCertificate;
        @JsonProperty(value="primaryDbEndpoint")
        private Endpoint primaryDbEndpoint;
        @JsonProperty(value="instanceEndpoints")
        private List<DbInstanceEndpoint> instanceEndpoints;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder caCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
            this.__explicitlySet__.add("caCertificate");
            return this;
        }

        public Builder primaryDbEndpoint(Endpoint primaryDbEndpoint) {
            this.primaryDbEndpoint = primaryDbEndpoint;
            this.__explicitlySet__.add("primaryDbEndpoint");
            return this;
        }

        public Builder instanceEndpoints(List<DbInstanceEndpoint> instanceEndpoints) {
            this.instanceEndpoints = instanceEndpoints;
            this.__explicitlySet__.add("instanceEndpoints");
            return this;
        }

        public ConnectionDetails build() {
            ConnectionDetails model = new ConnectionDetails(this.caCertificate, this.primaryDbEndpoint, this.instanceEndpoints);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("caCertificate")) {
                this.caCertificate(model.getCaCertificate());
            }
            if (model.wasPropertyExplicitlySet("primaryDbEndpoint")) {
                this.primaryDbEndpoint(model.getPrimaryDbEndpoint());
            }
            if (model.wasPropertyExplicitlySet("instanceEndpoints")) {
                this.instanceEndpoints(model.getInstanceEndpoints());
            }
            return this;
        }
    }
}

