/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.psql.model.DbInstance;
import com.oracle.bmc.psql.model.ManagementPolicy;
import com.oracle.bmc.psql.model.NetworkDetails;
import com.oracle.bmc.psql.model.SourceDetails;
import com.oracle.bmc.psql.model.StorageDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystem
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="adminUsername")
    private final String adminUsername;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="systemType")
    private final SystemType systemType;
    @JsonProperty(value="dbVersion")
    private final String dbVersion;
    @JsonProperty(value="configId")
    private final String configId;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="instanceOcpuCount")
    private final Integer instanceOcpuCount;
    @JsonProperty(value="instanceMemorySizeInGBs")
    private final Integer instanceMemorySizeInGBs;
    @JsonProperty(value="instanceCount")
    private final Integer instanceCount;
    @JsonProperty(value="instances")
    private final List<DbInstance> instances;
    @JsonProperty(value="storageDetails")
    private final StorageDetails storageDetails;
    @JsonProperty(value="networkDetails")
    private final NetworkDetails networkDetails;
    @JsonProperty(value="managementPolicy")
    private final ManagementPolicy managementPolicy;
    @JsonProperty(value="source")
    private final SourceDetails source;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "description", "compartmentId", "timeCreated", "timeUpdated", "lifecycleState", "lifecycleDetails", "adminUsername", "freeformTags", "definedTags", "systemTags", "systemType", "dbVersion", "configId", "shape", "instanceOcpuCount", "instanceMemorySizeInGBs", "instanceCount", "instances", "storageDetails", "networkDetails", "managementPolicy", "source"})
    public DbSystem(String id, String displayName, String description, String compartmentId, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String lifecycleDetails, String adminUsername, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, SystemType systemType, String dbVersion, String configId, String shape, Integer instanceOcpuCount, Integer instanceMemorySizeInGBs, Integer instanceCount, List<DbInstance> instances, StorageDetails storageDetails, NetworkDetails networkDetails, ManagementPolicy managementPolicy, SourceDetails source) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.compartmentId = compartmentId;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.adminUsername = adminUsername;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.systemType = systemType;
        this.dbVersion = dbVersion;
        this.configId = configId;
        this.shape = shape;
        this.instanceOcpuCount = instanceOcpuCount;
        this.instanceMemorySizeInGBs = instanceMemorySizeInGBs;
        this.instanceCount = instanceCount;
        this.instances = instances;
        this.storageDetails = storageDetails;
        this.networkDetails = networkDetails;
        this.managementPolicy = managementPolicy;
        this.source = source;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public SystemType getSystemType() {
        return this.systemType;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getShape() {
        return this.shape;
    }

    public Integer getInstanceOcpuCount() {
        return this.instanceOcpuCount;
    }

    public Integer getInstanceMemorySizeInGBs() {
        return this.instanceMemorySizeInGBs;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public List<DbInstance> getInstances() {
        return this.instances;
    }

    public StorageDetails getStorageDetails() {
        return this.storageDetails;
    }

    public NetworkDetails getNetworkDetails() {
        return this.networkDetails;
    }

    public ManagementPolicy getManagementPolicy() {
        return this.managementPolicy;
    }

    public SourceDetails getSource() {
        return this.source;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbSystem(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", adminUsername=").append(String.valueOf(this.adminUsername));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", systemType=").append(String.valueOf((Object)this.systemType));
        sb.append(", dbVersion=").append(String.valueOf(this.dbVersion));
        sb.append(", configId=").append(String.valueOf(this.configId));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", instanceOcpuCount=").append(String.valueOf(this.instanceOcpuCount));
        sb.append(", instanceMemorySizeInGBs=").append(String.valueOf(this.instanceMemorySizeInGBs));
        sb.append(", instanceCount=").append(String.valueOf(this.instanceCount));
        sb.append(", instances=").append(String.valueOf(this.instances));
        sb.append(", storageDetails=").append(String.valueOf((Object)this.storageDetails));
        sb.append(", networkDetails=").append(String.valueOf((Object)this.networkDetails));
        sb.append(", managementPolicy=").append(String.valueOf((Object)this.managementPolicy));
        sb.append(", source=").append(String.valueOf((Object)this.source));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbSystem)) {
            return false;
        }
        DbSystem other = (DbSystem)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.adminUsername, other.adminUsername) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals((Object)this.systemType, (Object)other.systemType) && Objects.equals(this.dbVersion, other.dbVersion) && Objects.equals(this.configId, other.configId) && Objects.equals(this.shape, other.shape) && Objects.equals(this.instanceOcpuCount, other.instanceOcpuCount) && Objects.equals(this.instanceMemorySizeInGBs, other.instanceMemorySizeInGBs) && Objects.equals(this.instanceCount, other.instanceCount) && Objects.equals(this.instances, other.instances) && Objects.equals((Object)this.storageDetails, (Object)other.storageDetails) && Objects.equals((Object)this.networkDetails, (Object)other.networkDetails) && Objects.equals((Object)this.managementPolicy, (Object)other.managementPolicy) && Objects.equals((Object)this.source, (Object)other.source) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.adminUsername == null ? 43 : this.adminUsername.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.systemType == null ? 43 : this.systemType.hashCode());
        result = result * 59 + (this.dbVersion == null ? 43 : this.dbVersion.hashCode());
        result = result * 59 + (this.configId == null ? 43 : this.configId.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.instanceOcpuCount == null ? 43 : this.instanceOcpuCount.hashCode());
        result = result * 59 + (this.instanceMemorySizeInGBs == null ? 43 : this.instanceMemorySizeInGBs.hashCode());
        result = result * 59 + (this.instanceCount == null ? 43 : this.instanceCount.hashCode());
        result = result * 59 + (this.instances == null ? 43 : this.instances.hashCode());
        result = result * 59 + (this.storageDetails == null ? 43 : this.storageDetails.hashCode());
        result = result * 59 + (this.networkDetails == null ? 43 : this.networkDetails.hashCode());
        result = result * 59 + (this.managementPolicy == null ? 43 : this.managementPolicy.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SystemType implements BmcEnum
    {
        OciOptimizedStorage("OCI_OPTIMIZED_STORAGE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SystemType> map;

        private SystemType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SystemType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SystemType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SystemType.class);
            map = new HashMap<String, SystemType>();
            for (SystemType v : SystemType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        NeedsAttention("NEEDS_ATTENTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="adminUsername")
        private String adminUsername;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="systemType")
        private SystemType systemType;
        @JsonProperty(value="dbVersion")
        private String dbVersion;
        @JsonProperty(value="configId")
        private String configId;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="instanceOcpuCount")
        private Integer instanceOcpuCount;
        @JsonProperty(value="instanceMemorySizeInGBs")
        private Integer instanceMemorySizeInGBs;
        @JsonProperty(value="instanceCount")
        private Integer instanceCount;
        @JsonProperty(value="instances")
        private List<DbInstance> instances;
        @JsonProperty(value="storageDetails")
        private StorageDetails storageDetails;
        @JsonProperty(value="networkDetails")
        private NetworkDetails networkDetails;
        @JsonProperty(value="managementPolicy")
        private ManagementPolicy managementPolicy;
        @JsonProperty(value="source")
        private SourceDetails source;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder adminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
            this.__explicitlySet__.add("adminUsername");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder systemType(SystemType systemType) {
            this.systemType = systemType;
            this.__explicitlySet__.add("systemType");
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            this.__explicitlySet__.add("dbVersion");
            return this;
        }

        public Builder configId(String configId) {
            this.configId = configId;
            this.__explicitlySet__.add("configId");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder instanceOcpuCount(Integer instanceOcpuCount) {
            this.instanceOcpuCount = instanceOcpuCount;
            this.__explicitlySet__.add("instanceOcpuCount");
            return this;
        }

        public Builder instanceMemorySizeInGBs(Integer instanceMemorySizeInGBs) {
            this.instanceMemorySizeInGBs = instanceMemorySizeInGBs;
            this.__explicitlySet__.add("instanceMemorySizeInGBs");
            return this;
        }

        public Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            this.__explicitlySet__.add("instanceCount");
            return this;
        }

        public Builder instances(List<DbInstance> instances) {
            this.instances = instances;
            this.__explicitlySet__.add("instances");
            return this;
        }

        public Builder storageDetails(StorageDetails storageDetails) {
            this.storageDetails = storageDetails;
            this.__explicitlySet__.add("storageDetails");
            return this;
        }

        public Builder networkDetails(NetworkDetails networkDetails) {
            this.networkDetails = networkDetails;
            this.__explicitlySet__.add("networkDetails");
            return this;
        }

        public Builder managementPolicy(ManagementPolicy managementPolicy) {
            this.managementPolicy = managementPolicy;
            this.__explicitlySet__.add("managementPolicy");
            return this;
        }

        public Builder source(SourceDetails source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public DbSystem build() {
            DbSystem model = new DbSystem(this.id, this.displayName, this.description, this.compartmentId, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.adminUsername, this.freeformTags, this.definedTags, this.systemTags, this.systemType, this.dbVersion, this.configId, this.shape, this.instanceOcpuCount, this.instanceMemorySizeInGBs, this.instanceCount, this.instances, this.storageDetails, this.networkDetails, this.managementPolicy, this.source);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbSystem model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("adminUsername")) {
                this.adminUsername(model.getAdminUsername());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("systemType")) {
                this.systemType(model.getSystemType());
            }
            if (model.wasPropertyExplicitlySet("dbVersion")) {
                this.dbVersion(model.getDbVersion());
            }
            if (model.wasPropertyExplicitlySet("configId")) {
                this.configId(model.getConfigId());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("instanceOcpuCount")) {
                this.instanceOcpuCount(model.getInstanceOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("instanceMemorySizeInGBs")) {
                this.instanceMemorySizeInGBs(model.getInstanceMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("instanceCount")) {
                this.instanceCount(model.getInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("instances")) {
                this.instances(model.getInstances());
            }
            if (model.wasPropertyExplicitlySet("storageDetails")) {
                this.storageDetails(model.getStorageDetails());
            }
            if (model.wasPropertyExplicitlySet("networkDetails")) {
                this.networkDetails(model.getNetworkDetails());
            }
            if (model.wasPropertyExplicitlySet("managementPolicy")) {
                this.managementPolicy(model.getManagementPolicy());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            return this;
        }
    }
}

