/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.psql.model.BackupPolicy;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class MonthlyBackupPolicy
extends BackupPolicy {
    @JsonProperty(value="backupStart")
    private final String backupStart;
    @JsonProperty(value="daysOfTheMonth")
    private final List<Integer> daysOfTheMonth;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public MonthlyBackupPolicy(Integer retentionDays, String backupStart, List<Integer> daysOfTheMonth) {
        super(retentionDays);
        this.backupStart = backupStart;
        this.daysOfTheMonth = daysOfTheMonth;
    }

    public String getBackupStart() {
        return this.backupStart;
    }

    public List<Integer> getDaysOfTheMonth() {
        return this.daysOfTheMonth;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MonthlyBackupPolicy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", backupStart=").append(String.valueOf(this.backupStart));
        sb.append(", daysOfTheMonth=").append(String.valueOf(this.daysOfTheMonth));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonthlyBackupPolicy)) {
            return false;
        }
        MonthlyBackupPolicy other = (MonthlyBackupPolicy)((Object)o);
        return Objects.equals(this.backupStart, other.backupStart) && Objects.equals(this.daysOfTheMonth, other.daysOfTheMonth) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.backupStart == null ? 43 : this.backupStart.hashCode());
        result = result * 59 + (this.daysOfTheMonth == null ? 43 : this.daysOfTheMonth.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="retentionDays")
        private Integer retentionDays;
        @JsonProperty(value="backupStart")
        private String backupStart;
        @JsonProperty(value="daysOfTheMonth")
        private List<Integer> daysOfTheMonth;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder retentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
            this.__explicitlySet__.add("retentionDays");
            return this;
        }

        public Builder backupStart(String backupStart) {
            this.backupStart = backupStart;
            this.__explicitlySet__.add("backupStart");
            return this;
        }

        public Builder daysOfTheMonth(List<Integer> daysOfTheMonth) {
            this.daysOfTheMonth = daysOfTheMonth;
            this.__explicitlySet__.add("daysOfTheMonth");
            return this;
        }

        public MonthlyBackupPolicy build() {
            MonthlyBackupPolicy model = new MonthlyBackupPolicy(this.retentionDays, this.backupStart, this.daysOfTheMonth);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MonthlyBackupPolicy model) {
            if (model.wasPropertyExplicitlySet("retentionDays")) {
                this.retentionDays(model.getRetentionDays());
            }
            if (model.wasPropertyExplicitlySet("backupStart")) {
                this.backupStart(model.getBackupStart());
            }
            if (model.wasPropertyExplicitlySet("daysOfTheMonth")) {
                this.daysOfTheMonth(model.getDaysOfTheMonth());
            }
            return this;
        }
    }
}

