/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NetworkDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="primaryDbEndpointPrivateIp")
    private final String primaryDbEndpointPrivateIp;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;

    @Deprecated
    @ConstructorProperties(value={"subnetId", "primaryDbEndpointPrivateIp", "nsgIds"})
    public NetworkDetails(String subnetId, String primaryDbEndpointPrivateIp, List<String> nsgIds) {
        this.subnetId = subnetId;
        this.primaryDbEndpointPrivateIp = primaryDbEndpointPrivateIp;
        this.nsgIds = nsgIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getPrimaryDbEndpointPrivateIp() {
        return this.primaryDbEndpointPrivateIp;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NetworkDetails(");
        sb.append("super=").append(super.toString());
        sb.append("subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", primaryDbEndpointPrivateIp=").append(String.valueOf(this.primaryDbEndpointPrivateIp));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkDetails)) {
            return false;
        }
        NetworkDetails other = (NetworkDetails)((Object)o);
        return Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.primaryDbEndpointPrivateIp, other.primaryDbEndpointPrivateIp) && Objects.equals(this.nsgIds, other.nsgIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.primaryDbEndpointPrivateIp == null ? 43 : this.primaryDbEndpointPrivateIp.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="primaryDbEndpointPrivateIp")
        private String primaryDbEndpointPrivateIp;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder primaryDbEndpointPrivateIp(String primaryDbEndpointPrivateIp) {
            this.primaryDbEndpointPrivateIp = primaryDbEndpointPrivateIp;
            this.__explicitlySet__.add("primaryDbEndpointPrivateIp");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public NetworkDetails build() {
            NetworkDetails model = new NetworkDetails(this.subnetId, this.primaryDbEndpointPrivateIp, this.nsgIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NetworkDetails model) {
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("primaryDbEndpointPrivateIp")) {
                this.primaryDbEndpointPrivateIp(model.getPrimaryDbEndpointPrivateIp());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            return this;
        }
    }
}

