/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.psql.model.PatchInstruction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="operation")
@JsonFilter(value="explicitlySetFilter")
public final class PatchInsertInstruction
extends PatchInstruction {
    @JsonProperty(value="value")
    private final Object value;
    @JsonProperty(value="selectedItem")
    private final String selectedItem;
    @JsonProperty(value="position")
    private final Position position;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PatchInsertInstruction(String selection, Object value, String selectedItem, Position position) {
        super(selection);
        this.value = value;
        this.selectedItem = selectedItem;
        this.position = position;
    }

    public Object getValue() {
        return this.value;
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }

    public Position getPosition() {
        return this.position;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PatchInsertInstruction(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", selectedItem=").append(String.valueOf(this.selectedItem));
        sb.append(", position=").append(String.valueOf((Object)this.position));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchInsertInstruction)) {
            return false;
        }
        PatchInsertInstruction other = (PatchInsertInstruction)((Object)o);
        return Objects.equals(this.value, other.value) && Objects.equals(this.selectedItem, other.selectedItem) && Objects.equals((Object)this.position, (Object)other.position) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.selectedItem == null ? 43 : this.selectedItem.hashCode());
        result = result * 59 + (this.position == null ? 43 : this.position.hashCode());
        return result;
    }

    public static enum Position implements BmcEnum
    {
        Before("BEFORE"),
        After("AFTER");

        private final String value;
        private static Map<String, Position> map;

        private Position(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Position create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Position: " + key);
        }

        static {
            map = new HashMap<String, Position>();
            for (Position v : Position.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="selection")
        private String selection;
        @JsonProperty(value="value")
        private Object value;
        @JsonProperty(value="selectedItem")
        private String selectedItem;
        @JsonProperty(value="position")
        private Position position;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder selection(String selection) {
            this.selection = selection;
            this.__explicitlySet__.add("selection");
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder selectedItem(String selectedItem) {
            this.selectedItem = selectedItem;
            this.__explicitlySet__.add("selectedItem");
            return this;
        }

        public Builder position(Position position) {
            this.position = position;
            this.__explicitlySet__.add("position");
            return this;
        }

        public PatchInsertInstruction build() {
            PatchInsertInstruction model = new PatchInsertInstruction(this.selection, this.value, this.selectedItem, this.position);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PatchInsertInstruction model) {
            if (model.wasPropertyExplicitlySet("selection")) {
                this.selection(model.getSelection());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("selectedItem")) {
                this.selectedItem(model.getSelectedItem());
            }
            if (model.wasPropertyExplicitlySet("position")) {
                this.position(model.getPosition());
            }
            return this;
        }
    }
}

