/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RestartDbInstanceInDbSystemDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dbInstanceId")
    private final String dbInstanceId;
    @JsonProperty(value="restartType")
    private final RestartType restartType;

    @Deprecated
    @ConstructorProperties(value={"dbInstanceId", "restartType"})
    public RestartDbInstanceInDbSystemDetails(String dbInstanceId, RestartType restartType) {
        this.dbInstanceId = dbInstanceId;
        this.restartType = restartType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDbInstanceId() {
        return this.dbInstanceId;
    }

    public RestartType getRestartType() {
        return this.restartType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RestartDbInstanceInDbSystemDetails(");
        sb.append("super=").append(super.toString());
        sb.append("dbInstanceId=").append(String.valueOf(this.dbInstanceId));
        sb.append(", restartType=").append(String.valueOf((Object)this.restartType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestartDbInstanceInDbSystemDetails)) {
            return false;
        }
        RestartDbInstanceInDbSystemDetails other = (RestartDbInstanceInDbSystemDetails)((Object)o);
        return Objects.equals(this.dbInstanceId, other.dbInstanceId) && Objects.equals((Object)this.restartType, (Object)other.restartType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dbInstanceId == null ? 43 : this.dbInstanceId.hashCode());
        result = result * 59 + (this.restartType == null ? 43 : this.restartType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RestartType implements BmcEnum
    {
        Normal("NORMAL"),
        NodeReboot("NODE_REBOOT");

        private final String value;
        private static Map<String, RestartType> map;

        private RestartType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RestartType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid RestartType: " + key);
        }

        static {
            map = new HashMap<String, RestartType>();
            for (RestartType v : RestartType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dbInstanceId")
        private String dbInstanceId;
        @JsonProperty(value="restartType")
        private RestartType restartType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dbInstanceId(String dbInstanceId) {
            this.dbInstanceId = dbInstanceId;
            this.__explicitlySet__.add("dbInstanceId");
            return this;
        }

        public Builder restartType(RestartType restartType) {
            this.restartType = restartType;
            this.__explicitlySet__.add("restartType");
            return this;
        }

        public RestartDbInstanceInDbSystemDetails build() {
            RestartDbInstanceInDbSystemDetails model = new RestartDbInstanceInDbSystemDetails(this.dbInstanceId, this.restartType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RestartDbInstanceInDbSystemDetails model) {
            if (model.wasPropertyExplicitlySet("dbInstanceId")) {
                this.dbInstanceId(model.getDbInstanceId());
            }
            if (model.wasPropertyExplicitlySet("restartType")) {
                this.restartType(model.getRestartType());
            }
            return this;
        }
    }
}

