/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.psql.model.ShapeMemoryOptions;
import com.oracle.bmc.psql.model.ShapeOcpuOptions;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ShapeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="isFlexible")
    private final Boolean isFlexible;
    @JsonProperty(value="ocpuCount")
    private final Integer ocpuCount;
    @JsonProperty(value="memorySizeInGBs")
    private final Integer memorySizeInGBs;
    @JsonProperty(value="shapeOcpuOptions")
    private final ShapeOcpuOptions shapeOcpuOptions;
    @JsonProperty(value="shapeMemoryOptions")
    private final ShapeMemoryOptions shapeMemoryOptions;

    @Deprecated
    @ConstructorProperties(value={"id", "shape", "isFlexible", "ocpuCount", "memorySizeInGBs", "shapeOcpuOptions", "shapeMemoryOptions"})
    public ShapeSummary(String id, String shape, Boolean isFlexible, Integer ocpuCount, Integer memorySizeInGBs, ShapeOcpuOptions shapeOcpuOptions, ShapeMemoryOptions shapeMemoryOptions) {
        this.id = id;
        this.shape = shape;
        this.isFlexible = isFlexible;
        this.ocpuCount = ocpuCount;
        this.memorySizeInGBs = memorySizeInGBs;
        this.shapeOcpuOptions = shapeOcpuOptions;
        this.shapeMemoryOptions = shapeMemoryOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getShape() {
        return this.shape;
    }

    public Boolean getIsFlexible() {
        return this.isFlexible;
    }

    public Integer getOcpuCount() {
        return this.ocpuCount;
    }

    public Integer getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public ShapeOcpuOptions getShapeOcpuOptions() {
        return this.shapeOcpuOptions;
    }

    public ShapeMemoryOptions getShapeMemoryOptions() {
        return this.shapeMemoryOptions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ShapeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", isFlexible=").append(String.valueOf(this.isFlexible));
        sb.append(", ocpuCount=").append(String.valueOf(this.ocpuCount));
        sb.append(", memorySizeInGBs=").append(String.valueOf(this.memorySizeInGBs));
        sb.append(", shapeOcpuOptions=").append(String.valueOf((Object)this.shapeOcpuOptions));
        sb.append(", shapeMemoryOptions=").append(String.valueOf((Object)this.shapeMemoryOptions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShapeSummary)) {
            return false;
        }
        ShapeSummary other = (ShapeSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.shape, other.shape) && Objects.equals(this.isFlexible, other.isFlexible) && Objects.equals(this.ocpuCount, other.ocpuCount) && Objects.equals(this.memorySizeInGBs, other.memorySizeInGBs) && Objects.equals((Object)this.shapeOcpuOptions, (Object)other.shapeOcpuOptions) && Objects.equals((Object)this.shapeMemoryOptions, (Object)other.shapeMemoryOptions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.isFlexible == null ? 43 : this.isFlexible.hashCode());
        result = result * 59 + (this.ocpuCount == null ? 43 : this.ocpuCount.hashCode());
        result = result * 59 + (this.memorySizeInGBs == null ? 43 : this.memorySizeInGBs.hashCode());
        result = result * 59 + (this.shapeOcpuOptions == null ? 43 : this.shapeOcpuOptions.hashCode());
        result = result * 59 + (this.shapeMemoryOptions == null ? 43 : this.shapeMemoryOptions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="isFlexible")
        private Boolean isFlexible;
        @JsonProperty(value="ocpuCount")
        private Integer ocpuCount;
        @JsonProperty(value="memorySizeInGBs")
        private Integer memorySizeInGBs;
        @JsonProperty(value="shapeOcpuOptions")
        private ShapeOcpuOptions shapeOcpuOptions;
        @JsonProperty(value="shapeMemoryOptions")
        private ShapeMemoryOptions shapeMemoryOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder isFlexible(Boolean isFlexible) {
            this.isFlexible = isFlexible;
            this.__explicitlySet__.add("isFlexible");
            return this;
        }

        public Builder ocpuCount(Integer ocpuCount) {
            this.ocpuCount = ocpuCount;
            this.__explicitlySet__.add("ocpuCount");
            return this;
        }

        public Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public Builder shapeOcpuOptions(ShapeOcpuOptions shapeOcpuOptions) {
            this.shapeOcpuOptions = shapeOcpuOptions;
            this.__explicitlySet__.add("shapeOcpuOptions");
            return this;
        }

        public Builder shapeMemoryOptions(ShapeMemoryOptions shapeMemoryOptions) {
            this.shapeMemoryOptions = shapeMemoryOptions;
            this.__explicitlySet__.add("shapeMemoryOptions");
            return this;
        }

        public ShapeSummary build() {
            ShapeSummary model = new ShapeSummary(this.id, this.shape, this.isFlexible, this.ocpuCount, this.memorySizeInGBs, this.shapeOcpuOptions, this.shapeMemoryOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ShapeSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("isFlexible")) {
                this.isFlexible(model.getIsFlexible());
            }
            if (model.wasPropertyExplicitlySet("ocpuCount")) {
                this.ocpuCount(model.getOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("memorySizeInGBs")) {
                this.memorySizeInGBs(model.getMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("shapeOcpuOptions")) {
                this.shapeOcpuOptions(model.getShapeOcpuOptions());
            }
            if (model.wasPropertyExplicitlySet("shapeMemoryOptions")) {
                this.shapeMemoryOptions(model.getShapeMemoryOptions());
            }
            return this;
        }
    }
}

