/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.psql.model.ManagementPolicyDetails;
import com.oracle.bmc.psql.model.UpdateDbConfigParams;
import com.oracle.bmc.psql.model.UpdateNetworkDetails;
import com.oracle.bmc.psql.model.UpdateStorageDetailsParams;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateDbSystemDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="instanceOcpuCount")
    private final Integer instanceOcpuCount;
    @JsonProperty(value="instanceMemorySizeInGBs")
    private final Integer instanceMemorySizeInGBs;
    @JsonProperty(value="dbConfigurationParams")
    private final UpdateDbConfigParams dbConfigurationParams;
    @JsonProperty(value="managementPolicy")
    private final ManagementPolicyDetails managementPolicy;
    @JsonProperty(value="storageDetails")
    private final UpdateStorageDetailsParams storageDetails;
    @JsonProperty(value="networkDetails")
    private final UpdateNetworkDetails networkDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "description", "shape", "instanceOcpuCount", "instanceMemorySizeInGBs", "dbConfigurationParams", "managementPolicy", "storageDetails", "networkDetails", "freeformTags", "definedTags"})
    public UpdateDbSystemDetails(String displayName, String description, String shape, Integer instanceOcpuCount, Integer instanceMemorySizeInGBs, UpdateDbConfigParams dbConfigurationParams, ManagementPolicyDetails managementPolicy, UpdateStorageDetailsParams storageDetails, UpdateNetworkDetails networkDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.description = description;
        this.shape = shape;
        this.instanceOcpuCount = instanceOcpuCount;
        this.instanceMemorySizeInGBs = instanceMemorySizeInGBs;
        this.dbConfigurationParams = dbConfigurationParams;
        this.managementPolicy = managementPolicy;
        this.storageDetails = storageDetails;
        this.networkDetails = networkDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getShape() {
        return this.shape;
    }

    public Integer getInstanceOcpuCount() {
        return this.instanceOcpuCount;
    }

    public Integer getInstanceMemorySizeInGBs() {
        return this.instanceMemorySizeInGBs;
    }

    public UpdateDbConfigParams getDbConfigurationParams() {
        return this.dbConfigurationParams;
    }

    public ManagementPolicyDetails getManagementPolicy() {
        return this.managementPolicy;
    }

    public UpdateStorageDetailsParams getStorageDetails() {
        return this.storageDetails;
    }

    public UpdateNetworkDetails getNetworkDetails() {
        return this.networkDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateDbSystemDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", instanceOcpuCount=").append(String.valueOf(this.instanceOcpuCount));
        sb.append(", instanceMemorySizeInGBs=").append(String.valueOf(this.instanceMemorySizeInGBs));
        sb.append(", dbConfigurationParams=").append(String.valueOf((Object)this.dbConfigurationParams));
        sb.append(", managementPolicy=").append(String.valueOf((Object)this.managementPolicy));
        sb.append(", storageDetails=").append(String.valueOf((Object)this.storageDetails));
        sb.append(", networkDetails=").append(String.valueOf((Object)this.networkDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDbSystemDetails)) {
            return false;
        }
        UpdateDbSystemDetails other = (UpdateDbSystemDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.shape, other.shape) && Objects.equals(this.instanceOcpuCount, other.instanceOcpuCount) && Objects.equals(this.instanceMemorySizeInGBs, other.instanceMemorySizeInGBs) && Objects.equals((Object)this.dbConfigurationParams, (Object)other.dbConfigurationParams) && Objects.equals((Object)this.managementPolicy, (Object)other.managementPolicy) && Objects.equals((Object)this.storageDetails, (Object)other.storageDetails) && Objects.equals((Object)this.networkDetails, (Object)other.networkDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.instanceOcpuCount == null ? 43 : this.instanceOcpuCount.hashCode());
        result = result * 59 + (this.instanceMemorySizeInGBs == null ? 43 : this.instanceMemorySizeInGBs.hashCode());
        result = result * 59 + (this.dbConfigurationParams == null ? 43 : this.dbConfigurationParams.hashCode());
        result = result * 59 + (this.managementPolicy == null ? 43 : this.managementPolicy.hashCode());
        result = result * 59 + (this.storageDetails == null ? 43 : this.storageDetails.hashCode());
        result = result * 59 + (this.networkDetails == null ? 43 : this.networkDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="instanceOcpuCount")
        private Integer instanceOcpuCount;
        @JsonProperty(value="instanceMemorySizeInGBs")
        private Integer instanceMemorySizeInGBs;
        @JsonProperty(value="dbConfigurationParams")
        private UpdateDbConfigParams dbConfigurationParams;
        @JsonProperty(value="managementPolicy")
        private ManagementPolicyDetails managementPolicy;
        @JsonProperty(value="storageDetails")
        private UpdateStorageDetailsParams storageDetails;
        @JsonProperty(value="networkDetails")
        private UpdateNetworkDetails networkDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder instanceOcpuCount(Integer instanceOcpuCount) {
            this.instanceOcpuCount = instanceOcpuCount;
            this.__explicitlySet__.add("instanceOcpuCount");
            return this;
        }

        public Builder instanceMemorySizeInGBs(Integer instanceMemorySizeInGBs) {
            this.instanceMemorySizeInGBs = instanceMemorySizeInGBs;
            this.__explicitlySet__.add("instanceMemorySizeInGBs");
            return this;
        }

        public Builder dbConfigurationParams(UpdateDbConfigParams dbConfigurationParams) {
            this.dbConfigurationParams = dbConfigurationParams;
            this.__explicitlySet__.add("dbConfigurationParams");
            return this;
        }

        public Builder managementPolicy(ManagementPolicyDetails managementPolicy) {
            this.managementPolicy = managementPolicy;
            this.__explicitlySet__.add("managementPolicy");
            return this;
        }

        public Builder storageDetails(UpdateStorageDetailsParams storageDetails) {
            this.storageDetails = storageDetails;
            this.__explicitlySet__.add("storageDetails");
            return this;
        }

        public Builder networkDetails(UpdateNetworkDetails networkDetails) {
            this.networkDetails = networkDetails;
            this.__explicitlySet__.add("networkDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateDbSystemDetails build() {
            UpdateDbSystemDetails model = new UpdateDbSystemDetails(this.displayName, this.description, this.shape, this.instanceOcpuCount, this.instanceMemorySizeInGBs, this.dbConfigurationParams, this.managementPolicy, this.storageDetails, this.networkDetails, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateDbSystemDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("instanceOcpuCount")) {
                this.instanceOcpuCount(model.getInstanceOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("instanceMemorySizeInGBs")) {
                this.instanceMemorySizeInGBs(model.getInstanceMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("dbConfigurationParams")) {
                this.dbConfigurationParams(model.getDbConfigurationParams());
            }
            if (model.wasPropertyExplicitlySet("managementPolicy")) {
                this.managementPolicy(model.getManagementPolicy());
            }
            if (model.wasPropertyExplicitlySet("storageDetails")) {
                this.storageDetails(model.getStorageDetails());
            }
            if (model.wasPropertyExplicitlySet("networkDetails")) {
                this.networkDetails(model.getNetworkDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

