/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.psql.model.BackupPolicy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class WeeklyBackupPolicy
extends BackupPolicy {
    @JsonProperty(value="daysOfTheWeek")
    private final List<DaysOfTheWeek> daysOfTheWeek;
    @JsonProperty(value="backupStart")
    private final String backupStart;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public WeeklyBackupPolicy(Integer retentionDays, List<DaysOfTheWeek> daysOfTheWeek, String backupStart) {
        super(retentionDays);
        this.daysOfTheWeek = daysOfTheWeek;
        this.backupStart = backupStart;
    }

    public List<DaysOfTheWeek> getDaysOfTheWeek() {
        return this.daysOfTheWeek;
    }

    public String getBackupStart() {
        return this.backupStart;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WeeklyBackupPolicy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", daysOfTheWeek=").append(String.valueOf(this.daysOfTheWeek));
        sb.append(", backupStart=").append(String.valueOf(this.backupStart));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WeeklyBackupPolicy)) {
            return false;
        }
        WeeklyBackupPolicy other = (WeeklyBackupPolicy)((Object)o);
        return Objects.equals(this.daysOfTheWeek, other.daysOfTheWeek) && Objects.equals(this.backupStart, other.backupStart) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.daysOfTheWeek == null ? 43 : this.daysOfTheWeek.hashCode());
        result = result * 59 + (this.backupStart == null ? 43 : this.backupStart.hashCode());
        return result;
    }

    public static enum DaysOfTheWeek implements BmcEnum
    {
        Sunday("SUNDAY"),
        Monday("MONDAY"),
        Tuesday("TUESDAY"),
        Wednesday("WEDNESDAY"),
        Thursday("THURSDAY"),
        Friday("FRIDAY"),
        Saturday("SATURDAY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DaysOfTheWeek> map;

        private DaysOfTheWeek(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DaysOfTheWeek create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DaysOfTheWeek', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DaysOfTheWeek.class);
            map = new HashMap<String, DaysOfTheWeek>();
            for (DaysOfTheWeek v : DaysOfTheWeek.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="retentionDays")
        private Integer retentionDays;
        @JsonProperty(value="daysOfTheWeek")
        private List<DaysOfTheWeek> daysOfTheWeek;
        @JsonProperty(value="backupStart")
        private String backupStart;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder retentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
            this.__explicitlySet__.add("retentionDays");
            return this;
        }

        public Builder daysOfTheWeek(List<DaysOfTheWeek> daysOfTheWeek) {
            this.daysOfTheWeek = daysOfTheWeek;
            this.__explicitlySet__.add("daysOfTheWeek");
            return this;
        }

        public Builder backupStart(String backupStart) {
            this.backupStart = backupStart;
            this.__explicitlySet__.add("backupStart");
            return this;
        }

        public WeeklyBackupPolicy build() {
            WeeklyBackupPolicy model = new WeeklyBackupPolicy(this.retentionDays, this.daysOfTheWeek, this.backupStart);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WeeklyBackupPolicy model) {
            if (model.wasPropertyExplicitlySet("retentionDays")) {
                this.retentionDays(model.getRetentionDays());
            }
            if (model.wasPropertyExplicitlySet("daysOfTheWeek")) {
                this.daysOfTheWeek(model.getDaysOfTheWeek());
            }
            if (model.wasPropertyExplicitlySet("backupStart")) {
                this.backupStart(model.getBackupStart());
            }
            return this;
        }
    }
}

