/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.psql.model.FailoverDbSystemDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class FailoverDbSystemRequest
extends BmcRequest<FailoverDbSystemDetails> {
    private String dbSystemId;
    private FailoverDbSystemDetails failoverDbSystemDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public FailoverDbSystemDetails getFailoverDbSystemDetails() {
        return this.failoverDbSystemDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public FailoverDbSystemDetails getBody$() {
        return this.failoverDbSystemDetails;
    }

    public Builder toBuilder() {
        return new Builder().dbSystemId(this.dbSystemId).failoverDbSystemDetails(this.failoverDbSystemDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(",failoverDbSystemDetails=").append(String.valueOf((Object)this.failoverDbSystemDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FailoverDbSystemRequest)) {
            return false;
        }
        FailoverDbSystemRequest other = (FailoverDbSystemRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals((Object)this.failoverDbSystemDetails, (Object)other.failoverDbSystemDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.failoverDbSystemDetails == null ? 43 : this.failoverDbSystemDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<FailoverDbSystemRequest, FailoverDbSystemDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbSystemId = null;
        private FailoverDbSystemDetails failoverDbSystemDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder failoverDbSystemDetails(FailoverDbSystemDetails failoverDbSystemDetails) {
            this.failoverDbSystemDetails = failoverDbSystemDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(FailoverDbSystemRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.failoverDbSystemDetails(o.getFailoverDbSystemDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public FailoverDbSystemRequest build() {
            FailoverDbSystemRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(FailoverDbSystemDetails body) {
            this.failoverDbSystemDetails(body);
            return this;
        }

        public FailoverDbSystemRequest buildWithoutInvocationCallback() {
            FailoverDbSystemRequest request = new FailoverDbSystemRequest();
            request.dbSystemId = this.dbSystemId;
            request.failoverDbSystemDetails = this.failoverDbSystemDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

