/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.psql.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDefaultConfigurationRequest
extends BmcRequest<Void> {
    private String defaultConfigurationId;
    private String opcRequestId;

    public String getDefaultConfigurationId() {
        return this.defaultConfigurationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().defaultConfigurationId(this.defaultConfigurationId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",defaultConfigurationId=").append(String.valueOf(this.defaultConfigurationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDefaultConfigurationRequest)) {
            return false;
        }
        GetDefaultConfigurationRequest other = (GetDefaultConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.defaultConfigurationId, other.defaultConfigurationId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.defaultConfigurationId == null ? 43 : this.defaultConfigurationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDefaultConfigurationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String defaultConfigurationId = null;
        private String opcRequestId = null;

        public Builder defaultConfigurationId(String defaultConfigurationId) {
            this.defaultConfigurationId = defaultConfigurationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDefaultConfigurationRequest o) {
            this.defaultConfigurationId(o.getDefaultConfigurationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDefaultConfigurationRequest build() {
            GetDefaultConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDefaultConfigurationRequest buildWithoutInvocationCallback() {
            GetDefaultConfigurationRequest request = new GetDefaultConfigurationRequest();
            request.defaultConfigurationId = this.defaultConfigurationId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

