/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PutMessage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final Long id;
    @JsonProperty(value="expireAfter")
    private final Date expireAfter;

    @Deprecated
    @ConstructorProperties(value={"id", "expireAfter"})
    public PutMessage(Long id, Date expireAfter) {
        this.id = id;
        this.expireAfter = expireAfter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getId() {
        return this.id;
    }

    public Date getExpireAfter() {
        return this.expireAfter;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PutMessage(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", expireAfter=").append(String.valueOf(this.expireAfter));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutMessage)) {
            return false;
        }
        PutMessage other = (PutMessage)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.expireAfter, other.expireAfter) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.expireAfter == null ? 43 : this.expireAfter.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private Long id;
        @JsonProperty(value="expireAfter")
        private Date expireAfter;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(Long id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder expireAfter(Date expireAfter) {
            this.expireAfter = expireAfter;
            this.__explicitlySet__.add("expireAfter");
            return this;
        }

        public PutMessage build() {
            PutMessage model = new PutMessage(this.id, this.expireAfter);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PutMessage model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("expireAfter")) {
                this.expireAfter(model.getExpireAfter());
            }
            return this;
        }
    }
}

