/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.queue.model.UpdateMessagesResultEntry;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateMessagesResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="serverFailures")
    private final Integer serverFailures;
    @JsonProperty(value="clientFailures")
    private final Integer clientFailures;
    @JsonProperty(value="entries")
    private final List<UpdateMessagesResultEntry> entries;

    @Deprecated
    @ConstructorProperties(value={"serverFailures", "clientFailures", "entries"})
    public UpdateMessagesResult(Integer serverFailures, Integer clientFailures, List<UpdateMessagesResultEntry> entries) {
        this.serverFailures = serverFailures;
        this.clientFailures = clientFailures;
        this.entries = entries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getServerFailures() {
        return this.serverFailures;
    }

    public Integer getClientFailures() {
        return this.clientFailures;
    }

    public List<UpdateMessagesResultEntry> getEntries() {
        return this.entries;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateMessagesResult(");
        sb.append("super=").append(super.toString());
        sb.append("serverFailures=").append(String.valueOf(this.serverFailures));
        sb.append(", clientFailures=").append(String.valueOf(this.clientFailures));
        sb.append(", entries=").append(String.valueOf(this.entries));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateMessagesResult)) {
            return false;
        }
        UpdateMessagesResult other = (UpdateMessagesResult)((Object)o);
        return Objects.equals(this.serverFailures, other.serverFailures) && Objects.equals(this.clientFailures, other.clientFailures) && Objects.equals(this.entries, other.entries) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.serverFailures == null ? 43 : this.serverFailures.hashCode());
        result = result * 59 + (this.clientFailures == null ? 43 : this.clientFailures.hashCode());
        result = result * 59 + (this.entries == null ? 43 : this.entries.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="serverFailures")
        private Integer serverFailures;
        @JsonProperty(value="clientFailures")
        private Integer clientFailures;
        @JsonProperty(value="entries")
        private List<UpdateMessagesResultEntry> entries;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder serverFailures(Integer serverFailures) {
            this.serverFailures = serverFailures;
            this.__explicitlySet__.add("serverFailures");
            return this;
        }

        public Builder clientFailures(Integer clientFailures) {
            this.clientFailures = clientFailures;
            this.__explicitlySet__.add("clientFailures");
            return this;
        }

        public Builder entries(List<UpdateMessagesResultEntry> entries) {
            this.entries = entries;
            this.__explicitlySet__.add("entries");
            return this;
        }

        public UpdateMessagesResult build() {
            UpdateMessagesResult model = new UpdateMessagesResult(this.serverFailures, this.clientFailures, this.entries);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateMessagesResult model) {
            if (model.wasPropertyExplicitlySet("serverFailures")) {
                this.serverFailures(model.getServerFailures());
            }
            if (model.wasPropertyExplicitlySet("clientFailures")) {
                this.clientFailures(model.getClientFailures());
            }
            if (model.wasPropertyExplicitlySet("entries")) {
                this.entries(model.getEntries());
            }
            return this;
        }
    }
}

