/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.queue.model.ChangeQueueCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeQueueCompartmentRequest
extends BmcRequest<ChangeQueueCompartmentDetails> {
    private String queueId;
    private ChangeQueueCompartmentDetails changeQueueCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getQueueId() {
        return this.queueId;
    }

    public ChangeQueueCompartmentDetails getChangeQueueCompartmentDetails() {
        return this.changeQueueCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChangeQueueCompartmentDetails getBody$() {
        return this.changeQueueCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().queueId(this.queueId).changeQueueCompartmentDetails(this.changeQueueCompartmentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",queueId=").append(String.valueOf(this.queueId));
        sb.append(",changeQueueCompartmentDetails=").append(String.valueOf((Object)this.changeQueueCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeQueueCompartmentRequest)) {
            return false;
        }
        ChangeQueueCompartmentRequest other = (ChangeQueueCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.queueId, other.queueId) && Objects.equals((Object)this.changeQueueCompartmentDetails, (Object)other.changeQueueCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.queueId == null ? 43 : this.queueId.hashCode());
        result = result * 59 + (this.changeQueueCompartmentDetails == null ? 43 : this.changeQueueCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeQueueCompartmentRequest, ChangeQueueCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String queueId = null;
        private ChangeQueueCompartmentDetails changeQueueCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public Builder changeQueueCompartmentDetails(ChangeQueueCompartmentDetails changeQueueCompartmentDetails) {
            this.changeQueueCompartmentDetails = changeQueueCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeQueueCompartmentRequest o) {
            this.queueId(o.getQueueId());
            this.changeQueueCompartmentDetails(o.getChangeQueueCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeQueueCompartmentRequest build() {
            ChangeQueueCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeQueueCompartmentDetails body) {
            this.changeQueueCompartmentDetails(body);
            return this;
        }

        public ChangeQueueCompartmentRequest buildWithoutInvocationCallback() {
            ChangeQueueCompartmentRequest request = new ChangeQueueCompartmentRequest();
            request.queueId = this.queueId;
            request.changeQueueCompartmentDetails = this.changeQueueCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

