/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMessagesRequest
extends BmcRequest<Void> {
    private String queueId;
    private Integer visibilityInSeconds;
    private Integer timeoutInSeconds;
    private Integer limit;
    private String opcRequestId;
    private String channelFilter;

    public String getQueueId() {
        return this.queueId;
    }

    public Integer getVisibilityInSeconds() {
        return this.visibilityInSeconds;
    }

    public Integer getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getChannelFilter() {
        return this.channelFilter;
    }

    public Builder toBuilder() {
        return new Builder().queueId(this.queueId).visibilityInSeconds(this.visibilityInSeconds).timeoutInSeconds(this.timeoutInSeconds).limit(this.limit).opcRequestId(this.opcRequestId).channelFilter(this.channelFilter);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",queueId=").append(String.valueOf(this.queueId));
        sb.append(",visibilityInSeconds=").append(String.valueOf(this.visibilityInSeconds));
        sb.append(",timeoutInSeconds=").append(String.valueOf(this.timeoutInSeconds));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",channelFilter=").append(String.valueOf(this.channelFilter));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMessagesRequest)) {
            return false;
        }
        GetMessagesRequest other = (GetMessagesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.queueId, other.queueId) && Objects.equals(this.visibilityInSeconds, other.visibilityInSeconds) && Objects.equals(this.timeoutInSeconds, other.timeoutInSeconds) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.channelFilter, other.channelFilter);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.queueId == null ? 43 : this.queueId.hashCode());
        result = result * 59 + (this.visibilityInSeconds == null ? 43 : this.visibilityInSeconds.hashCode());
        result = result * 59 + (this.timeoutInSeconds == null ? 43 : this.timeoutInSeconds.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.channelFilter == null ? 43 : this.channelFilter.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMessagesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String queueId = null;
        private Integer visibilityInSeconds = null;
        private Integer timeoutInSeconds = null;
        private Integer limit = null;
        private String opcRequestId = null;
        private String channelFilter = null;

        public Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public Builder visibilityInSeconds(Integer visibilityInSeconds) {
            this.visibilityInSeconds = visibilityInSeconds;
            return this;
        }

        public Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder channelFilter(String channelFilter) {
            this.channelFilter = channelFilter;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMessagesRequest o) {
            this.queueId(o.getQueueId());
            this.visibilityInSeconds(o.getVisibilityInSeconds());
            this.timeoutInSeconds(o.getTimeoutInSeconds());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.channelFilter(o.getChannelFilter());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMessagesRequest build() {
            GetMessagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMessagesRequest buildWithoutInvocationCallback() {
            GetMessagesRequest request = new GetMessagesRequest();
            request.queueId = this.queueId;
            request.visibilityInSeconds = this.visibilityInSeconds;
            request.timeoutInSeconds = this.timeoutInSeconds;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            request.channelFilter = this.channelFilter;
            return request;
        }
    }
}

