/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Stats
extends ExplicitlySetBmcModel {
    @JsonProperty(value="visibleMessages")
    private final Long visibleMessages;
    @JsonProperty(value="inFlightMessages")
    private final Long inFlightMessages;
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;

    @Deprecated
    @ConstructorProperties(value={"visibleMessages", "inFlightMessages", "sizeInBytes"})
    public Stats(Long visibleMessages, Long inFlightMessages, Long sizeInBytes) {
        this.visibleMessages = visibleMessages;
        this.inFlightMessages = inFlightMessages;
        this.sizeInBytes = sizeInBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getVisibleMessages() {
        return this.visibleMessages;
    }

    public Long getInFlightMessages() {
        return this.inFlightMessages;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Stats(");
        sb.append("super=").append(super.toString());
        sb.append("visibleMessages=").append(String.valueOf(this.visibleMessages));
        sb.append(", inFlightMessages=").append(String.valueOf(this.inFlightMessages));
        sb.append(", sizeInBytes=").append(String.valueOf(this.sizeInBytes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Stats)) {
            return false;
        }
        Stats other = (Stats)((Object)o);
        return Objects.equals(this.visibleMessages, other.visibleMessages) && Objects.equals(this.inFlightMessages, other.inFlightMessages) && Objects.equals(this.sizeInBytes, other.sizeInBytes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.visibleMessages == null ? 43 : this.visibleMessages.hashCode());
        result = result * 59 + (this.inFlightMessages == null ? 43 : this.inFlightMessages.hashCode());
        result = result * 59 + (this.sizeInBytes == null ? 43 : this.sizeInBytes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="visibleMessages")
        private Long visibleMessages;
        @JsonProperty(value="inFlightMessages")
        private Long inFlightMessages;
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder visibleMessages(Long visibleMessages) {
            this.visibleMessages = visibleMessages;
            this.__explicitlySet__.add("visibleMessages");
            return this;
        }

        public Builder inFlightMessages(Long inFlightMessages) {
            this.inFlightMessages = inFlightMessages;
            this.__explicitlySet__.add("inFlightMessages");
            return this;
        }

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Stats build() {
            Stats model = new Stats(this.visibleMessages, this.inFlightMessages, this.sizeInBytes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Stats model) {
            if (model.wasPropertyExplicitlySet("visibleMessages")) {
                this.visibleMessages(model.getVisibleMessages());
            }
            if (model.wasPropertyExplicitlySet("inFlightMessages")) {
                this.inFlightMessages(model.getInFlightMessages());
            }
            if (model.wasPropertyExplicitlySet("sizeInBytes")) {
                this.sizeInBytes(model.getSizeInBytes());
            }
            return this;
        }
    }
}

