/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PurgeQueueDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="purgeType")
    private final PurgeType purgeType;
    @JsonProperty(value="channelIds")
    private final List<String> channelIds;

    @Deprecated
    @ConstructorProperties(value={"purgeType", "channelIds"})
    public PurgeQueueDetails(PurgeType purgeType, List<String> channelIds) {
        this.purgeType = purgeType;
        this.channelIds = channelIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public PurgeType getPurgeType() {
        return this.purgeType;
    }

    public List<String> getChannelIds() {
        return this.channelIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PurgeQueueDetails(");
        sb.append("super=").append(super.toString());
        sb.append("purgeType=").append(String.valueOf((Object)this.purgeType));
        sb.append(", channelIds=").append(String.valueOf(this.channelIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PurgeQueueDetails)) {
            return false;
        }
        PurgeQueueDetails other = (PurgeQueueDetails)((Object)o);
        return Objects.equals((Object)this.purgeType, (Object)other.purgeType) && Objects.equals(this.channelIds, other.channelIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.purgeType == null ? 43 : this.purgeType.hashCode());
        result = result * 59 + (this.channelIds == null ? 43 : this.channelIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PurgeType implements BmcEnum
    {
        Normal("NORMAL"),
        Dlq("DLQ"),
        Both("BOTH");

        private final String value;
        private static Map<String, PurgeType> map;

        private PurgeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PurgeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PurgeType: " + key);
        }

        static {
            map = new HashMap<String, PurgeType>();
            for (PurgeType v : PurgeType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="purgeType")
        private PurgeType purgeType;
        @JsonProperty(value="channelIds")
        private List<String> channelIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder purgeType(PurgeType purgeType) {
            this.purgeType = purgeType;
            this.__explicitlySet__.add("purgeType");
            return this;
        }

        public Builder channelIds(List<String> channelIds) {
            this.channelIds = channelIds;
            this.__explicitlySet__.add("channelIds");
            return this;
        }

        public PurgeQueueDetails build() {
            PurgeQueueDetails model = new PurgeQueueDetails(this.purgeType, this.channelIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PurgeQueueDetails model) {
            if (model.wasPropertyExplicitlySet("purgeType")) {
                this.purgeType(model.getPurgeType());
            }
            if (model.wasPropertyExplicitlySet("channelIds")) {
                this.channelIds(model.getChannelIds());
            }
            return this;
        }
    }
}

