/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetStatsRequest
extends BmcRequest<Void> {
    private String queueId;
    private String opcRequestId;
    private String channelId;

    public String getQueueId() {
        return this.queueId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public Builder toBuilder() {
        return new Builder().queueId(this.queueId).opcRequestId(this.opcRequestId).channelId(this.channelId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",queueId=").append(String.valueOf(this.queueId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",channelId=").append(String.valueOf(this.channelId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetStatsRequest)) {
            return false;
        }
        GetStatsRequest other = (GetStatsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.queueId, other.queueId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.channelId, other.channelId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.queueId == null ? 43 : this.queueId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.channelId == null ? 43 : this.channelId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetStatsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String queueId = null;
        private String opcRequestId = null;
        private String channelId = null;

        public Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStatsRequest o) {
            this.queueId(o.getQueueId());
            this.opcRequestId(o.getOpcRequestId());
            this.channelId(o.getChannelId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStatsRequest build() {
            GetStatsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetStatsRequest buildWithoutInvocationCallback() {
            GetStatsRequest request = new GetStatsRequest();
            request.queueId = this.queueId;
            request.opcRequestId = this.opcRequestId;
            request.channelId = this.channelId;
            return request;
        }
    }
}

