/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.redis;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.redis.RedisCluster;
import com.oracle.bmc.redis.RedisClusterPaginators;
import com.oracle.bmc.redis.RedisClusterWaiters;
import com.oracle.bmc.redis.model.RedisClusterCollection;
import com.oracle.bmc.redis.model.WorkRequest;
import com.oracle.bmc.redis.model.WorkRequestErrorCollection;
import com.oracle.bmc.redis.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.redis.model.WorkRequestSummaryCollection;
import com.oracle.bmc.redis.requests.CancelWorkRequestRequest;
import com.oracle.bmc.redis.requests.ChangeRedisClusterCompartmentRequest;
import com.oracle.bmc.redis.requests.CreateRedisClusterRequest;
import com.oracle.bmc.redis.requests.DeleteRedisClusterRequest;
import com.oracle.bmc.redis.requests.GetRedisClusterRequest;
import com.oracle.bmc.redis.requests.GetWorkRequestRequest;
import com.oracle.bmc.redis.requests.ListRedisClustersRequest;
import com.oracle.bmc.redis.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.redis.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.redis.requests.ListWorkRequestsRequest;
import com.oracle.bmc.redis.requests.UpdateRedisClusterRequest;
import com.oracle.bmc.redis.responses.CancelWorkRequestResponse;
import com.oracle.bmc.redis.responses.ChangeRedisClusterCompartmentResponse;
import com.oracle.bmc.redis.responses.CreateRedisClusterResponse;
import com.oracle.bmc.redis.responses.DeleteRedisClusterResponse;
import com.oracle.bmc.redis.responses.GetRedisClusterResponse;
import com.oracle.bmc.redis.responses.GetWorkRequestResponse;
import com.oracle.bmc.redis.responses.ListRedisClustersResponse;
import com.oracle.bmc.redis.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.redis.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.redis.responses.ListWorkRequestsResponse;
import com.oracle.bmc.redis.responses.UpdateRedisClusterResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisClusterClient
extends BaseSyncClient
implements RedisCluster {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("REDISCLUSTER").serviceEndpointPrefix("").serviceEndpointTemplate("https://redis.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RedisClusterClient.class);
    private final RedisClusterWaiters waiters;
    private final RedisClusterPaginators paginators;

    RedisClusterClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("RedisCluster-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new RedisClusterWaiters(executorService, this);
        this.paginators = new RedisClusterPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("RedisCluster", "CancelWorkRequest", "").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20220315").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeRedisClusterCompartmentResponse changeRedisClusterCompartment(ChangeRedisClusterCompartmentRequest request) {
        Validate.notBlank((String)request.getRedisClusterId(), (String)"redisClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRedisClusterCompartmentDetails(), "changeRedisClusterCompartmentDetails is required");
        return (ChangeRedisClusterCompartmentResponse)this.clientCall(request, ChangeRedisClusterCompartmentResponse::builder).logger(LOG, "changeRedisClusterCompartment").serviceDetails("RedisCluster", "ChangeRedisClusterCompartment", "").method(Method.POST).requestBuilder(ChangeRedisClusterCompartmentRequest::builder).basePath("/20220315").appendPathParam("redisClusters").appendPathParam(request.getRedisClusterId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeRedisClusterCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeRedisClusterCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateRedisClusterResponse createRedisCluster(CreateRedisClusterRequest request) {
        Objects.requireNonNull(request.getCreateRedisClusterDetails(), "createRedisClusterDetails is required");
        return (CreateRedisClusterResponse)this.clientCall(request, CreateRedisClusterResponse::builder).logger(LOG, "createRedisCluster").serviceDetails("RedisCluster", "CreateRedisCluster", "").method(Method.POST).requestBuilder(CreateRedisClusterRequest::builder).basePath("/20220315").appendPathParam("redisClusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.redis.model.RedisCluster.class, CreateRedisClusterResponse.Builder::redisCluster).handleResponseHeaderString("etag", CreateRedisClusterResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateRedisClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateRedisClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteRedisClusterResponse deleteRedisCluster(DeleteRedisClusterRequest request) {
        Validate.notBlank((String)request.getRedisClusterId(), (String)"redisClusterId must not be blank", (Object[])new Object[0]);
        return (DeleteRedisClusterResponse)this.clientCall(request, DeleteRedisClusterResponse::builder).logger(LOG, "deleteRedisCluster").serviceDetails("RedisCluster", "DeleteRedisCluster", "").method(Method.DELETE).requestBuilder(DeleteRedisClusterRequest::builder).basePath("/20220315").appendPathParam("redisClusters").appendPathParam(request.getRedisClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteRedisClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRedisClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetRedisClusterResponse getRedisCluster(GetRedisClusterRequest request) {
        Validate.notBlank((String)request.getRedisClusterId(), (String)"redisClusterId must not be blank", (Object[])new Object[0]);
        return (GetRedisClusterResponse)this.clientCall(request, GetRedisClusterResponse::builder).logger(LOG, "getRedisCluster").serviceDetails("RedisCluster", "GetRedisCluster", "").method(Method.GET).requestBuilder(GetRedisClusterRequest::builder).basePath("/20220315").appendPathParam("redisClusters").appendPathParam(request.getRedisClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.redis.model.RedisCluster.class, GetRedisClusterResponse.Builder::redisCluster).handleResponseHeaderString("etag", GetRedisClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRedisClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("RedisCluster", "GetWorkRequest", "").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220315").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListRedisClustersResponse listRedisClusters(ListRedisClustersRequest request) {
        return (ListRedisClustersResponse)this.clientCall(request, ListRedisClustersResponse::builder).logger(LOG, "listRedisClusters").serviceDetails("RedisCluster", "ListRedisClusters", "").method(Method.GET).requestBuilder(ListRedisClustersRequest::builder).basePath("/20220315").appendPathParam("redisClusters").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RedisClusterCollection.class, ListRedisClustersResponse.Builder::redisClusterCollection).handleResponseHeaderString("opc-request-id", ListRedisClustersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRedisClustersResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("RedisCluster", "ListWorkRequestErrors", "").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220315").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("RedisCluster", "ListWorkRequestLogs", "").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220315").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("RedisCluster", "ListWorkRequests", "").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220315").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateRedisClusterResponse updateRedisCluster(UpdateRedisClusterRequest request) {
        Validate.notBlank((String)request.getRedisClusterId(), (String)"redisClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRedisClusterDetails(), "updateRedisClusterDetails is required");
        return (UpdateRedisClusterResponse)this.clientCall(request, UpdateRedisClusterResponse::builder).logger(LOG, "updateRedisCluster").serviceDetails("RedisCluster", "UpdateRedisCluster", "").method(Method.PUT).requestBuilder(UpdateRedisClusterRequest::builder).basePath("/20220315").appendPathParam("redisClusters").appendPathParam(request.getRedisClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateRedisClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateRedisClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RedisClusterWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public RedisClusterPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public RedisClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RedisClusterClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedisClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RedisClusterClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedisClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RedisClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedisClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RedisClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedisClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RedisClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedisClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RedisClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedisClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RedisClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedisClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RedisClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RedisClusterClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "redis";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"redis");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public RedisClusterClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RedisClusterClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

