/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.redis;

import com.oracle.bmc.redis.RedisCluster;
import com.oracle.bmc.redis.model.RedisCluster;
import com.oracle.bmc.redis.requests.GetRedisClusterRequest;
import com.oracle.bmc.redis.requests.GetWorkRequestRequest;
import com.oracle.bmc.redis.responses.GetRedisClusterResponse;
import com.oracle.bmc.redis.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class RedisClusterWaiters {
    private final ExecutorService executorService;
    private final RedisCluster client;

    public RedisClusterWaiters(ExecutorService executorService, RedisCluster client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetRedisClusterRequest, GetRedisClusterResponse> forRedisCluster(GetRedisClusterRequest request, RedisCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRedisCluster(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRedisClusterRequest, GetRedisClusterResponse> forRedisCluster(GetRedisClusterRequest request, RedisCluster.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRedisCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRedisClusterRequest, GetRedisClusterResponse> forRedisCluster(GetRedisClusterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, RedisCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRedisCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRedisClusterRequest, GetRedisClusterResponse> forRedisCluster(BmcGenericWaiter waiter, GetRedisClusterRequest request, RedisCluster.LifecycleState ... targetStates) {
        final HashSet<RedisCluster.LifecycleState> targetStatesSet = new HashSet<RedisCluster.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetRedisClusterRequest, GetRedisClusterResponse>(){

            @Override
            public GetRedisClusterResponse apply(GetRedisClusterRequest request) {
                return RedisClusterWaiters.this.client.getRedisCluster(request);
            }
        }, (Predicate)new Predicate<GetRedisClusterResponse>(){

            @Override
            public boolean test(GetRedisClusterResponse response) {
                return targetStatesSet.contains((Object)response.getRedisCluster().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)RedisCluster.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return RedisClusterWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

