/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.redis.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Node
extends ExplicitlySetBmcModel {
    @JsonProperty(value="privateEndpointFqdn")
    private final String privateEndpointFqdn;
    @JsonProperty(value="privateEndpointIpAddress")
    private final String privateEndpointIpAddress;
    @JsonProperty(value="displayName")
    private final String displayName;

    @Deprecated
    @ConstructorProperties(value={"privateEndpointFqdn", "privateEndpointIpAddress", "displayName"})
    public Node(String privateEndpointFqdn, String privateEndpointIpAddress, String displayName) {
        this.privateEndpointFqdn = privateEndpointFqdn;
        this.privateEndpointIpAddress = privateEndpointIpAddress;
        this.displayName = displayName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPrivateEndpointFqdn() {
        return this.privateEndpointFqdn;
    }

    public String getPrivateEndpointIpAddress() {
        return this.privateEndpointIpAddress;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Node(");
        sb.append("super=").append(super.toString());
        sb.append("privateEndpointFqdn=").append(String.valueOf(this.privateEndpointFqdn));
        sb.append(", privateEndpointIpAddress=").append(String.valueOf(this.privateEndpointIpAddress));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)((Object)o);
        return Objects.equals(this.privateEndpointFqdn, other.privateEndpointFqdn) && Objects.equals(this.privateEndpointIpAddress, other.privateEndpointIpAddress) && Objects.equals(this.displayName, other.displayName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.privateEndpointFqdn == null ? 43 : this.privateEndpointFqdn.hashCode());
        result = result * 59 + (this.privateEndpointIpAddress == null ? 43 : this.privateEndpointIpAddress.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="privateEndpointFqdn")
        private String privateEndpointFqdn;
        @JsonProperty(value="privateEndpointIpAddress")
        private String privateEndpointIpAddress;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder privateEndpointFqdn(String privateEndpointFqdn) {
            this.privateEndpointFqdn = privateEndpointFqdn;
            this.__explicitlySet__.add("privateEndpointFqdn");
            return this;
        }

        public Builder privateEndpointIpAddress(String privateEndpointIpAddress) {
            this.privateEndpointIpAddress = privateEndpointIpAddress;
            this.__explicitlySet__.add("privateEndpointIpAddress");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Node build() {
            Node model = new Node(this.privateEndpointFqdn, this.privateEndpointIpAddress, this.displayName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Node model) {
            if (model.wasPropertyExplicitlySet("privateEndpointFqdn")) {
                this.privateEndpointFqdn(model.getPrivateEndpointFqdn());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointIpAddress")) {
                this.privateEndpointIpAddress(model.getPrivateEndpointIpAddress());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            return this;
        }
    }
}

