/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.redis.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.redis.model.RedisCluster;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RedisClusterSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="lifecycleState")
    private final RedisCluster.LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="nodeCount")
    private final Integer nodeCount;
    @JsonProperty(value="nodeMemoryInGBs")
    private final Float nodeMemoryInGBs;
    @JsonProperty(value="primaryFqdn")
    private final String primaryFqdn;
    @JsonProperty(value="primaryEndpointIpAddress")
    private final String primaryEndpointIpAddress;
    @JsonProperty(value="replicasFqdn")
    private final String replicasFqdn;
    @JsonProperty(value="replicasEndpointIpAddress")
    private final String replicasEndpointIpAddress;
    @JsonProperty(value="softwareVersion")
    private final RedisCluster.SoftwareVersion softwareVersion;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "lifecycleState", "lifecycleDetails", "nodeCount", "nodeMemoryInGBs", "primaryFqdn", "primaryEndpointIpAddress", "replicasFqdn", "replicasEndpointIpAddress", "softwareVersion", "subnetId", "timeCreated", "timeUpdated", "nsgIds", "freeformTags", "definedTags", "systemTags"})
    public RedisClusterSummary(String id, String displayName, String compartmentId, RedisCluster.LifecycleState lifecycleState, String lifecycleDetails, Integer nodeCount, Float nodeMemoryInGBs, String primaryFqdn, String primaryEndpointIpAddress, String replicasFqdn, String replicasEndpointIpAddress, RedisCluster.SoftwareVersion softwareVersion, String subnetId, Date timeCreated, Date timeUpdated, List<String> nsgIds, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.nodeCount = nodeCount;
        this.nodeMemoryInGBs = nodeMemoryInGBs;
        this.primaryFqdn = primaryFqdn;
        this.primaryEndpointIpAddress = primaryEndpointIpAddress;
        this.replicasFqdn = replicasFqdn;
        this.replicasEndpointIpAddress = replicasEndpointIpAddress;
        this.softwareVersion = softwareVersion;
        this.subnetId = subnetId;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.nsgIds = nsgIds;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public RedisCluster.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public Float getNodeMemoryInGBs() {
        return this.nodeMemoryInGBs;
    }

    public String getPrimaryFqdn() {
        return this.primaryFqdn;
    }

    public String getPrimaryEndpointIpAddress() {
        return this.primaryEndpointIpAddress;
    }

    public String getReplicasFqdn() {
        return this.replicasFqdn;
    }

    public String getReplicasEndpointIpAddress() {
        return this.replicasEndpointIpAddress;
    }

    public RedisCluster.SoftwareVersion getSoftwareVersion() {
        return this.softwareVersion;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RedisClusterSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", nodeCount=").append(String.valueOf(this.nodeCount));
        sb.append(", nodeMemoryInGBs=").append(String.valueOf(this.nodeMemoryInGBs));
        sb.append(", primaryFqdn=").append(String.valueOf(this.primaryFqdn));
        sb.append(", primaryEndpointIpAddress=").append(String.valueOf(this.primaryEndpointIpAddress));
        sb.append(", replicasFqdn=").append(String.valueOf(this.replicasFqdn));
        sb.append(", replicasEndpointIpAddress=").append(String.valueOf(this.replicasEndpointIpAddress));
        sb.append(", softwareVersion=").append(String.valueOf((Object)this.softwareVersion));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisClusterSummary)) {
            return false;
        }
        RedisClusterSummary other = (RedisClusterSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.nodeCount, other.nodeCount) && Objects.equals(this.nodeMemoryInGBs, other.nodeMemoryInGBs) && Objects.equals(this.primaryFqdn, other.primaryFqdn) && Objects.equals(this.primaryEndpointIpAddress, other.primaryEndpointIpAddress) && Objects.equals(this.replicasFqdn, other.replicasFqdn) && Objects.equals(this.replicasEndpointIpAddress, other.replicasEndpointIpAddress) && Objects.equals((Object)this.softwareVersion, (Object)other.softwareVersion) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.nodeCount == null ? 43 : this.nodeCount.hashCode());
        result = result * 59 + (this.nodeMemoryInGBs == null ? 43 : this.nodeMemoryInGBs.hashCode());
        result = result * 59 + (this.primaryFqdn == null ? 43 : this.primaryFqdn.hashCode());
        result = result * 59 + (this.primaryEndpointIpAddress == null ? 43 : this.primaryEndpointIpAddress.hashCode());
        result = result * 59 + (this.replicasFqdn == null ? 43 : this.replicasFqdn.hashCode());
        result = result * 59 + (this.replicasEndpointIpAddress == null ? 43 : this.replicasEndpointIpAddress.hashCode());
        result = result * 59 + (this.softwareVersion == null ? 43 : this.softwareVersion.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private RedisCluster.LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="nodeCount")
        private Integer nodeCount;
        @JsonProperty(value="nodeMemoryInGBs")
        private Float nodeMemoryInGBs;
        @JsonProperty(value="primaryFqdn")
        private String primaryFqdn;
        @JsonProperty(value="primaryEndpointIpAddress")
        private String primaryEndpointIpAddress;
        @JsonProperty(value="replicasFqdn")
        private String replicasFqdn;
        @JsonProperty(value="replicasEndpointIpAddress")
        private String replicasEndpointIpAddress;
        @JsonProperty(value="softwareVersion")
        private RedisCluster.SoftwareVersion softwareVersion;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(RedisCluster.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            this.__explicitlySet__.add("nodeCount");
            return this;
        }

        public Builder nodeMemoryInGBs(Float nodeMemoryInGBs) {
            this.nodeMemoryInGBs = nodeMemoryInGBs;
            this.__explicitlySet__.add("nodeMemoryInGBs");
            return this;
        }

        public Builder primaryFqdn(String primaryFqdn) {
            this.primaryFqdn = primaryFqdn;
            this.__explicitlySet__.add("primaryFqdn");
            return this;
        }

        public Builder primaryEndpointIpAddress(String primaryEndpointIpAddress) {
            this.primaryEndpointIpAddress = primaryEndpointIpAddress;
            this.__explicitlySet__.add("primaryEndpointIpAddress");
            return this;
        }

        public Builder replicasFqdn(String replicasFqdn) {
            this.replicasFqdn = replicasFqdn;
            this.__explicitlySet__.add("replicasFqdn");
            return this;
        }

        public Builder replicasEndpointIpAddress(String replicasEndpointIpAddress) {
            this.replicasEndpointIpAddress = replicasEndpointIpAddress;
            this.__explicitlySet__.add("replicasEndpointIpAddress");
            return this;
        }

        public Builder softwareVersion(RedisCluster.SoftwareVersion softwareVersion) {
            this.softwareVersion = softwareVersion;
            this.__explicitlySet__.add("softwareVersion");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public RedisClusterSummary build() {
            RedisClusterSummary model = new RedisClusterSummary(this.id, this.displayName, this.compartmentId, this.lifecycleState, this.lifecycleDetails, this.nodeCount, this.nodeMemoryInGBs, this.primaryFqdn, this.primaryEndpointIpAddress, this.replicasFqdn, this.replicasEndpointIpAddress, this.softwareVersion, this.subnetId, this.timeCreated, this.timeUpdated, this.nsgIds, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RedisClusterSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("nodeCount")) {
                this.nodeCount(model.getNodeCount());
            }
            if (model.wasPropertyExplicitlySet("nodeMemoryInGBs")) {
                this.nodeMemoryInGBs(model.getNodeMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("primaryFqdn")) {
                this.primaryFqdn(model.getPrimaryFqdn());
            }
            if (model.wasPropertyExplicitlySet("primaryEndpointIpAddress")) {
                this.primaryEndpointIpAddress(model.getPrimaryEndpointIpAddress());
            }
            if (model.wasPropertyExplicitlySet("replicasFqdn")) {
                this.replicasFqdn(model.getReplicasFqdn());
            }
            if (model.wasPropertyExplicitlySet("replicasEndpointIpAddress")) {
                this.replicasEndpointIpAddress(model.getReplicasEndpointIpAddress());
            }
            if (model.wasPropertyExplicitlySet("softwareVersion")) {
                this.softwareVersion(model.getSoftwareVersion());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

