/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.redis.responses;

import com.oracle.bmc.redis.model.RedisCluster;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateRedisClusterResponse
extends BmcResponse {
    private String etag;
    private String opcWorkRequestId;
    private String opcRequestId;
    private RedisCluster redisCluster;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public RedisCluster getRedisCluster() {
        return this.redisCluster;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcWorkRequestId", "opcRequestId", "redisCluster"})
    private CreateRedisClusterResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcWorkRequestId, String opcRequestId, RedisCluster redisCluster) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcWorkRequestId = opcWorkRequestId;
        this.opcRequestId = opcRequestId;
        this.redisCluster = redisCluster;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",redisCluster=").append(String.valueOf((Object)this.redisCluster));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateRedisClusterResponse)) {
            return false;
        }
        CreateRedisClusterResponse other = (CreateRedisClusterResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.redisCluster, (Object)other.redisCluster);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.redisCluster == null ? 43 : this.redisCluster.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateRedisClusterResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcWorkRequestId;
        private String opcRequestId;
        private RedisCluster redisCluster;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder redisCluster(RedisCluster redisCluster) {
            this.redisCluster = redisCluster;
            return this;
        }

        public Builder copy(CreateRedisClusterResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.redisCluster(o.getRedisCluster());
            return this;
        }

        public CreateRedisClusterResponse build() {
            return new CreateRedisClusterResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcWorkRequestId, this.opcRequestId, this.redisCluster);
        }
    }
}

