/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.resourcemanager.ResourceManager;
import com.oracle.bmc.resourcemanager.model.ConfigurationSourceProviderSummary;
import com.oracle.bmc.resourcemanager.model.JobSummary;
import com.oracle.bmc.resourcemanager.model.LogEntry;
import com.oracle.bmc.resourcemanager.model.StackResourceDriftSummary;
import com.oracle.bmc.resourcemanager.model.StackSummary;
import com.oracle.bmc.resourcemanager.model.TemplateSummary;
import com.oracle.bmc.resourcemanager.model.WorkRequestError;
import com.oracle.bmc.resourcemanager.model.WorkRequestLogEntry;
import com.oracle.bmc.resourcemanager.model.WorkRequestSummary;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsRequest;
import com.oracle.bmc.resourcemanager.requests.ListConfigurationSourceProvidersRequest;
import com.oracle.bmc.resourcemanager.requests.ListJobsRequest;
import com.oracle.bmc.resourcemanager.requests.ListStackResourceDriftDetailsRequest;
import com.oracle.bmc.resourcemanager.requests.ListStacksRequest;
import com.oracle.bmc.resourcemanager.requests.ListTemplatesRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestsRequest;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsResponse;
import com.oracle.bmc.resourcemanager.responses.ListConfigurationSourceProvidersResponse;
import com.oracle.bmc.resourcemanager.responses.ListJobsResponse;
import com.oracle.bmc.resourcemanager.responses.ListStackResourceDriftDetailsResponse;
import com.oracle.bmc.resourcemanager.responses.ListStacksResponse;
import com.oracle.bmc.resourcemanager.responses.ListTemplatesResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestsResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class ResourceManagerPaginators {
    private final ResourceManager client;

    public Iterable<GetJobLogsResponse> getJobLogsResponseIterator(final GetJobLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<GetJobLogsRequest.Builder>(){

            public GetJobLogsRequest.Builder get() {
                return GetJobLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<GetJobLogsResponse, String>(){

            public String apply(GetJobLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<GetJobLogsRequest.Builder>, GetJobLogsRequest>(){

            public GetJobLogsRequest apply(RequestBuilderAndToken<GetJobLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((GetJobLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((GetJobLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<GetJobLogsRequest, GetJobLogsResponse>(){

            public GetJobLogsResponse apply(GetJobLogsRequest request) {
                return ResourceManagerPaginators.this.client.getJobLogs(request);
            }
        });
    }

    public Iterable<LogEntry> getJobLogsRecordIterator(final GetJobLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<GetJobLogsRequest.Builder>(){

            public GetJobLogsRequest.Builder get() {
                return GetJobLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<GetJobLogsResponse, String>(){

            public String apply(GetJobLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<GetJobLogsRequest.Builder>, GetJobLogsRequest>(){

            public GetJobLogsRequest apply(RequestBuilderAndToken<GetJobLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((GetJobLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((GetJobLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<GetJobLogsRequest, GetJobLogsResponse>(){

            public GetJobLogsResponse apply(GetJobLogsRequest request) {
                return ResourceManagerPaginators.this.client.getJobLogs(request);
            }
        }, (Function)new Function<GetJobLogsResponse, List<LogEntry>>(){

            public List<LogEntry> apply(GetJobLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListConfigurationSourceProvidersResponse> listConfigurationSourceProvidersResponseIterator(final ListConfigurationSourceProvidersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConfigurationSourceProvidersRequest.Builder>(){

            public ListConfigurationSourceProvidersRequest.Builder get() {
                return ListConfigurationSourceProvidersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConfigurationSourceProvidersResponse, String>(){

            public String apply(ListConfigurationSourceProvidersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConfigurationSourceProvidersRequest.Builder>, ListConfigurationSourceProvidersRequest>(){

            public ListConfigurationSourceProvidersRequest apply(RequestBuilderAndToken<ListConfigurationSourceProvidersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListConfigurationSourceProvidersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConfigurationSourceProvidersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListConfigurationSourceProvidersRequest, ListConfigurationSourceProvidersResponse>(){

            public ListConfigurationSourceProvidersResponse apply(ListConfigurationSourceProvidersRequest request) {
                return ResourceManagerPaginators.this.client.listConfigurationSourceProviders(request);
            }
        });
    }

    public Iterable<ConfigurationSourceProviderSummary> listConfigurationSourceProvidersRecordIterator(final ListConfigurationSourceProvidersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConfigurationSourceProvidersRequest.Builder>(){

            public ListConfigurationSourceProvidersRequest.Builder get() {
                return ListConfigurationSourceProvidersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConfigurationSourceProvidersResponse, String>(){

            public String apply(ListConfigurationSourceProvidersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConfigurationSourceProvidersRequest.Builder>, ListConfigurationSourceProvidersRequest>(){

            public ListConfigurationSourceProvidersRequest apply(RequestBuilderAndToken<ListConfigurationSourceProvidersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListConfigurationSourceProvidersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConfigurationSourceProvidersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListConfigurationSourceProvidersRequest, ListConfigurationSourceProvidersResponse>(){

            public ListConfigurationSourceProvidersResponse apply(ListConfigurationSourceProvidersRequest request) {
                return ResourceManagerPaginators.this.client.listConfigurationSourceProviders(request);
            }
        }, (Function)new Function<ListConfigurationSourceProvidersResponse, List<ConfigurationSourceProviderSummary>>(){

            public List<ConfigurationSourceProviderSummary> apply(ListConfigurationSourceProvidersResponse response) {
                return response.getConfigurationSourceProviderCollection().getItems();
            }
        });
    }

    public Iterable<ListJobsResponse> listJobsResponseIterator(final ListJobsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJobsRequest.Builder>(){

            public ListJobsRequest.Builder get() {
                return ListJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobsResponse, String>(){

            public String apply(ListJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobsRequest.Builder>, ListJobsRequest>(){

            public ListJobsRequest apply(RequestBuilderAndToken<ListJobsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobsRequest, ListJobsResponse>(){

            public ListJobsResponse apply(ListJobsRequest request) {
                return ResourceManagerPaginators.this.client.listJobs(request);
            }
        });
    }

    public Iterable<JobSummary> listJobsRecordIterator(final ListJobsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJobsRequest.Builder>(){

            public ListJobsRequest.Builder get() {
                return ListJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobsResponse, String>(){

            public String apply(ListJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobsRequest.Builder>, ListJobsRequest>(){

            public ListJobsRequest apply(RequestBuilderAndToken<ListJobsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListJobsRequest, ListJobsResponse>(){

            public ListJobsResponse apply(ListJobsRequest request) {
                return ResourceManagerPaginators.this.client.listJobs(request);
            }
        }, (Function)new Function<ListJobsResponse, List<JobSummary>>(){

            public List<JobSummary> apply(ListJobsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListStackResourceDriftDetailsResponse> listStackResourceDriftDetailsResponseIterator(final ListStackResourceDriftDetailsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListStackResourceDriftDetailsRequest.Builder>(){

            public ListStackResourceDriftDetailsRequest.Builder get() {
                return ListStackResourceDriftDetailsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStackResourceDriftDetailsResponse, String>(){

            public String apply(ListStackResourceDriftDetailsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStackResourceDriftDetailsRequest.Builder>, ListStackResourceDriftDetailsRequest>(){

            public ListStackResourceDriftDetailsRequest apply(RequestBuilderAndToken<ListStackResourceDriftDetailsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListStackResourceDriftDetailsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStackResourceDriftDetailsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListStackResourceDriftDetailsRequest, ListStackResourceDriftDetailsResponse>(){

            public ListStackResourceDriftDetailsResponse apply(ListStackResourceDriftDetailsRequest request) {
                return ResourceManagerPaginators.this.client.listStackResourceDriftDetails(request);
            }
        });
    }

    public Iterable<StackResourceDriftSummary> listStackResourceDriftDetailsRecordIterator(final ListStackResourceDriftDetailsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListStackResourceDriftDetailsRequest.Builder>(){

            public ListStackResourceDriftDetailsRequest.Builder get() {
                return ListStackResourceDriftDetailsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStackResourceDriftDetailsResponse, String>(){

            public String apply(ListStackResourceDriftDetailsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStackResourceDriftDetailsRequest.Builder>, ListStackResourceDriftDetailsRequest>(){

            public ListStackResourceDriftDetailsRequest apply(RequestBuilderAndToken<ListStackResourceDriftDetailsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListStackResourceDriftDetailsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStackResourceDriftDetailsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListStackResourceDriftDetailsRequest, ListStackResourceDriftDetailsResponse>(){

            public ListStackResourceDriftDetailsResponse apply(ListStackResourceDriftDetailsRequest request) {
                return ResourceManagerPaginators.this.client.listStackResourceDriftDetails(request);
            }
        }, (Function)new Function<ListStackResourceDriftDetailsResponse, List<StackResourceDriftSummary>>(){

            public List<StackResourceDriftSummary> apply(ListStackResourceDriftDetailsResponse response) {
                return response.getStackResourceDriftCollection().getItems();
            }
        });
    }

    public Iterable<ListStacksResponse> listStacksResponseIterator(final ListStacksRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListStacksRequest.Builder>(){

            public ListStacksRequest.Builder get() {
                return ListStacksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStacksResponse, String>(){

            public String apply(ListStacksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStacksRequest.Builder>, ListStacksRequest>(){

            public ListStacksRequest apply(RequestBuilderAndToken<ListStacksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListStacksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStacksRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListStacksRequest, ListStacksResponse>(){

            public ListStacksResponse apply(ListStacksRequest request) {
                return ResourceManagerPaginators.this.client.listStacks(request);
            }
        });
    }

    public Iterable<StackSummary> listStacksRecordIterator(final ListStacksRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListStacksRequest.Builder>(){

            public ListStacksRequest.Builder get() {
                return ListStacksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStacksResponse, String>(){

            public String apply(ListStacksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStacksRequest.Builder>, ListStacksRequest>(){

            public ListStacksRequest apply(RequestBuilderAndToken<ListStacksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListStacksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStacksRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListStacksRequest, ListStacksResponse>(){

            public ListStacksResponse apply(ListStacksRequest request) {
                return ResourceManagerPaginators.this.client.listStacks(request);
            }
        }, (Function)new Function<ListStacksResponse, List<StackSummary>>(){

            public List<StackSummary> apply(ListStacksResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTemplatesResponse> listTemplatesResponseIterator(final ListTemplatesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTemplatesRequest.Builder>(){

            public ListTemplatesRequest.Builder get() {
                return ListTemplatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTemplatesResponse, String>(){

            public String apply(ListTemplatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTemplatesRequest.Builder>, ListTemplatesRequest>(){

            public ListTemplatesRequest apply(RequestBuilderAndToken<ListTemplatesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTemplatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTemplatesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTemplatesRequest, ListTemplatesResponse>(){

            public ListTemplatesResponse apply(ListTemplatesRequest request) {
                return ResourceManagerPaginators.this.client.listTemplates(request);
            }
        });
    }

    public Iterable<TemplateSummary> listTemplatesRecordIterator(final ListTemplatesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTemplatesRequest.Builder>(){

            public ListTemplatesRequest.Builder get() {
                return ListTemplatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTemplatesResponse, String>(){

            public String apply(ListTemplatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTemplatesRequest.Builder>, ListTemplatesRequest>(){

            public ListTemplatesRequest apply(RequestBuilderAndToken<ListTemplatesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTemplatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTemplatesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTemplatesRequest, ListTemplatesResponse>(){

            public ListTemplatesResponse apply(ListTemplatesRequest request) {
                return ResourceManagerPaginators.this.client.listTemplates(request);
            }
        }, (Function)new Function<ListTemplatesResponse, List<TemplateSummary>>(){

            public List<TemplateSummary> apply(ListTemplatesResponse response) {
                return response.getTemplateSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ResourceManagerPaginators(ResourceManager client) {
        this.client = client;
    }
}

