/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.resourcemanager.requests.ChangeStackCompartmentRequest;
import com.oracle.bmc.resourcemanager.responses.ChangeStackCompartmentResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeStackCompartmentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeStackCompartmentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ChangeStackCompartmentRequest interceptRequest(ChangeStackCompartmentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ChangeStackCompartmentRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getStackId(), (String)"stackId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getChangeStackCompartmentDetails(), (String)"changeStackCompartmentDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180917").path("stacks").path(HttpUtils.encodePathSegment((String)request.getStackId())).path("actions").path("changeCompartment");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, ChangeStackCompartmentResponse> fromResponse() {
        Function<Response, ChangeStackCompartmentResponse> transformer = new Function<Response, ChangeStackCompartmentResponse>(){

            public ChangeStackCompartmentResponse apply(Response rawResponse) {
                Optional opcWorkRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.resourcemanager.responses.ChangeStackCompartmentResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ChangeStackCompartmentResponse.Builder builder = ChangeStackCompartmentResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                ChangeStackCompartmentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

